"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Resolver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _resolver_without_providers = require("./resolver_without_providers");
var _actions = require("../store/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The `Resolver` component to use. This sets up the DataAccessLayer provider. Use `ResolverWithoutProviders` in tests or in other scenarios where you want to provide a different (or fake) data access layer.
 */
// eslint-disable-next-line react/display-name
const Resolver = /*#__PURE__*/_react.default.memo(props => {
  const store = (0, _reactRedux.useSelector)(state => state.analyzer[props.resolverComponentInstanceID]);
  const dispatch = (0, _reactRedux.useDispatch)();
  if (!store) {
    dispatch((0, _actions.createResolver)({
      id: props.resolverComponentInstanceID
    }));
  }
  (0, _react.useEffect)(() => {
    if (props.shouldUpdate) {
      dispatch((0, _actions.createResolver)({
        id: props.resolverComponentInstanceID
      }));
    }
  }, [dispatch, props.shouldUpdate, props.resolverComponentInstanceID]);
  return /*#__PURE__*/_react.default.createElement(_resolver_without_providers.ResolverWithoutProviders, props);
});
exports.Resolver = Resolver;