"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ancestorsRequestAmount = ancestorsRequestAmount;
exports.descendantsLimit = exports.ancestorsWithoutAncestryField = exports.ancestorsWithAncestryField = void 0;
exports.descendantsRequestAmount = descendantsRequestAmount;
exports.generationsRequestAmount = generationsRequestAmount;
exports.generationsWithoutAncestryField = exports.generationsWithAncestryField = void 0;
exports.mock = mock;
exports.nodeStats = nodeStats;
var nodeModel = _interopRequireWildcard(require("../../../common/endpoint/models/node"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These values are only exported for testing. They should not be used directly. Instead use the functions below.
 */

/**
 * The limit for the ancestors in the server request when the ancestry field is defined in the schema.
 */
const ancestorsWithAncestryField = 200;
/**
 * The limit for the ancestors in the server request when the ancestry field is not defined in the schema.
 */
exports.ancestorsWithAncestryField = ancestorsWithAncestryField;
const ancestorsWithoutAncestryField = 20;
/**
 * The limit for the generations in the server request when the ancestry field is defined. Essentially this means
 * that the generations field will be ignored when the ancestry field is defined.
 */
exports.ancestorsWithoutAncestryField = ancestorsWithoutAncestryField;
const generationsWithAncestryField = 0;
/**
 * The limit for the generations in the server request when the ancestry field is not defined.
 */
exports.generationsWithAncestryField = generationsWithAncestryField;
const generationsWithoutAncestryField = 10;
/**
 * The limit for the descendants in the server request.
 */
exports.generationsWithoutAncestryField = generationsWithoutAncestryField;
const descendantsLimit = 500;

/**
 * Returns the number of ancestors we should use when requesting a tree from the server
 * depending on whether the schema received from the server has the ancestry field defined.
 */
exports.descendantsLimit = descendantsLimit;
function ancestorsRequestAmount(schema) {
  return (schema === null || schema === void 0 ? void 0 : schema.ancestry) !== undefined ? ancestorsWithAncestryField : ancestorsWithoutAncestryField;
}

/**
 * Returns the number of generations we should use when requesting a tree from the server
 * depending on whether the schema received from the server has the ancestry field defined.
 */
function generationsRequestAmount(schema) {
  return (schema === null || schema === void 0 ? void 0 : schema.ancestry) !== undefined ? generationsWithAncestryField : generationsWithoutAncestryField;
}

/**
 * The number of the descendants to use in a request to the server for a resolver tree.
 */
function descendantsRequestAmount() {
  return descendantsLimit;
}

/**
 * This returns a map of nodeIDs to the associated stats provided by the datasource.
 */
function nodeStats(tree) {
  const stats = new Map();
  for (const node of tree.nodes) {
    if (node.stats) {
      const nodeID = nodeModel.nodeID(node);
      stats.set(nodeID, node.stats);
    }
  }
  return stats;
}

/**
 * ResolverTree type is returned by the server. It organizes events into a complex structure. The
 * organization of events in the tree is done to associate metadata with the events. The client does not
 * use this metadata. Instead, the client flattens the tree into an array. Therefore we can safely
 * make a malformed ResolverTree for the purposes of the tests, so long as it is flattened in a predictable way.
 */
function mock({
  nodes
}) {
  if (nodes.length === 0) {
    return null;
  }
  const originNode = nodes[0];
  const originID = nodeModel.nodeID(originNode);
  if (!originID) {
    throw new Error('first mock event must include an nodeID.');
  }
  return {
    originID,
    nodes
  };
}