"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginContract = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _service = require("@kbn/security-solution-upselling/service");
var _nav_links = require("./common/links/nav_links");
var _breadcrumbs = require("./common/breadcrumbs");
var _contract_components = require("./contract_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class PluginContract {
  constructor(experimentalFeatures) {
    (0, _defineProperty2.default)(this, "componentsService", void 0);
    (0, _defineProperty2.default)(this, "upsellingService", void 0);
    (0, _defineProperty2.default)(this, "extraRoutes$", void 0);
    (0, _defineProperty2.default)(this, "appLinksSwitcher", void 0);
    (0, _defineProperty2.default)(this, "deepLinksFormatter", void 0);
    this.experimentalFeatures = experimentalFeatures;
    this.extraRoutes$ = new _rxjs.BehaviorSubject([]);
    this.componentsService = new _contract_components.ContractComponentsService();
    this.upsellingService = new _service.UpsellingService();
    this.appLinksSwitcher = appLinks => appLinks;
  }
  getStartServices() {
    return {
      extraRoutes$: this.extraRoutes$.asObservable(),
      getComponents$: this.componentsService.getComponents$.bind(this.componentsService),
      upselling: this.upsellingService
    };
  }
  getSetupContract() {
    return {
      resolver: lazyResolver,
      experimentalFeatures: {
        ...this.experimentalFeatures
      },
      setAppLinksSwitcher: appLinksSwitcher => {
        this.appLinksSwitcher = appLinksSwitcher;
      },
      setDeepLinksFormatter: deepLinksFormatter => {
        this.deepLinksFormatter = deepLinksFormatter;
      }
    };
  }
  getStartContract() {
    return {
      getNavLinks$: () => _nav_links.navLinks$,
      setExtraRoutes: extraRoutes => this.extraRoutes$.next(extraRoutes),
      setComponents: components => {
        this.componentsService.setComponents(components);
      },
      getBreadcrumbsNav$: () => _breadcrumbs.breadcrumbsNav$,
      getUpselling: () => this.upsellingService
    };
  }
  getStopContract() {
    return {};
  }
}
exports.PluginContract = PluginContract;
const lazyResolver = async () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  const {
    resolverPluginSetup
  } = await Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "resolver" */
  './resolver')));
  return resolverPluginSetup();
};