"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/core/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _telemetry = require("./common/lib/telemetry");
var _services = require("./common/lib/kibana/services");
var _translations = require("./common/translations");
var _constants = require("../common/constants");
var _links = require("./common/links");
var _deep_links = require("./common/links/deep_links");
var _use_license = require("./common/hooks/use_license");
var _experimental_features_service = require("./common/experimental_features_service");
var _lazy_endpoint_policy_edit_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_edit_extension");
var _lazy_endpoint_policy_create_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_extension");
var _lazy_endpoint_policy_create_multi_step_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_multi_step_extension");
var _lazy_endpoint_package_custom_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_package_custom_extension");
var _lazy_endpoint_policy_response_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_response_extension");
var _lazy_endpoint_generic_errors_list = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_generic_errors_list");
var _experimental_features = require("../common/experimental_features");
var _lazy_endpoint_custom_assets_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_custom_assets_extension");
var _plugin_contract = require("./plugin_contract");
var _top_values_popover_service = require("./app/components/top_values_popover/top_values_popover_service");
var _config_settings = require("../common/config_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class Plugin {
  /**
   * The current Kibana branch. e.g. 'main'
   */

  /**
   * The current Kibana version. e.g. '8.0.0' or '8.0.0-SNAPSHOT'
   */

  /**
   * Whether the environment is 'serverless' or 'traditional'
   */

  /**
   * For internal use. Specify which version of the Detection Rules fleet package to install
   * when upgrading rules. If not provided, the latest compatible package will be installed,
   * or if running from a dev environment or -SNAPSHOT build, the latest pre-release package
   * will be used (if fleet is available or not within an airgapped environment).
   *
   * Note: This is for `upgrade only`, which occurs by means of the `useUpgradeSecurityPackages`
   * hook when navigating to a Security Solution page. The package version specified in
   * `fleet_packages.json` in project root will always be installed first on Kibana start if
   * the package is not already installed.
   */

  constructor(initializerContext) {
    var _this$config$offering;
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "buildFlavor", void 0);
    (0, _defineProperty2.default)(this, "prebuiltRulesPackageVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    (0, _defineProperty2.default)(this, "configSettings", void 0);
    (0, _defineProperty2.default)(this, "queryService", new _public.QueryService());
    (0, _defineProperty2.default)(this, "nowProvider", new _public.NowProvider());
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "storage", new _public3.Storage(localStorage));
    (0, _defineProperty2.default)(this, "sessionStorage", new _public3.Storage(sessionStorage));
    /**
     * Lazily instantiated subPlugins.
     * See `subPlugins` method.
     */
    (0, _defineProperty2.default)(this, "_subPlugins", void 0);
    /**
     * Lazily instantiated `SecurityAppStore`.
     * See `store` method.
     */
    (0, _defineProperty2.default)(this, "_store", void 0);
    (0, _defineProperty2.default)(this, "_actionsRegistered", false);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []).features;
    this.configSettings = (0, _config_settings.parseConfigSettings)((_this$config$offering = this.config.offeringSettings) !== null && _this$config$offering !== void 0 ? _this$config$offering : {}).settings;
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.kibanaBranch = initializerContext.env.packageInfo.branch;
    this.buildFlavor = initializerContext.env.packageInfo.buildFlavor;
    this.prebuiltRulesPackageVersion = this.config.prebuiltRulesPackageVersion;
    this.contract = new _plugin_contract.PluginContract(this.experimentalFeatures);
    this.telemetry = new _telemetry.TelemetryService();
    this.storage = new _public3.Storage(window.localStorage);
  }
  setup(core, plugins) {
    var _this$queryService;
    (0, _telemetry.initTelemetry)({
      usageCollection: plugins.usageCollection
    }, _constants.APP_UI_ID);
    const telemetryContext = {
      prebuiltRulesPackageVersion: this.prebuiltRulesPackageVersion
    };
    this.telemetry.setup({
      analytics: core.analytics
    }, telemetryContext);
    (_this$queryService = this.queryService) === null || _this$queryService === void 0 ? void 0 : _this$queryService.setup({
      uiSettings: core.uiSettings,
      storage: this.storage,
      nowProvider: this.nowProvider
    });
    if (plugins.home) {
      plugins.home.featureCatalogue.registerSolution({
        id: _constants.APP_ID,
        title: _translations.SOLUTION_NAME,
        description: _i18n.i18n.translate('xpack.securitySolution.featureCatalogueDescription', {
          defaultMessage: 'Prevent, collect, detect, and respond to threats for unified protection across your infrastructure.'
        }),
        icon: 'logoSecurity',
        path: _constants.APP_PATH,
        order: 300
      });
    }

    /**
     * `StartServices` which are needed by the `renderApp` function when mounting any of the subPlugin applications.
     * This is a promise because these aren't available until the `start` lifecycle phase but they are referenced
     * in the `setup` lifecycle phase.
     */
    const startServices = async params => {
      const [coreStart, startPluginsDeps] = await core.getStartServices();
      const {
        apm
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@elastic/apm-rum')));
      const {
        SecuritySolutionTemplateWrapper
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app/home/template_wrapper')));
      const {
        savedObjectsTaggingOss,
        ...startPlugins
      } = startPluginsDeps;
      const query = this.queryService.start({
        uiSettings: core.uiSettings,
        storage: this.storage,
        http: core.http
      });

      // used for creating a custom stateful KQL Query Bar
      const customDataService = {
        ...startPlugins.data,
        query,
        // @ts-expect-error
        _name: 'custom'
      };

      // @ts-expect-error
      customDataService.query.filterManager._name = 'customFilterManager';
      const services = {
        ...coreStart,
        ...startPlugins,
        ...this.contract.getStartServices(),
        configSettings: this.configSettings,
        apm,
        savedObjectsTagging: savedObjectsTaggingOss.getTaggingApi(),
        setHeaderActionMenu: params.setHeaderActionMenu,
        storage: this.storage,
        sessionStorage: this.sessionStorage,
        security: startPluginsDeps.security,
        onAppLeave: params.onAppLeave,
        securityLayout: {
          getPluginWrapper: () => SecuritySolutionTemplateWrapper
        },
        contentManagement: startPluginsDeps.contentManagement,
        telemetry: this.telemetry.start(),
        customDataService,
        topValuesPopover: new _top_values_popover_service.TopValuesPopoverService()
      };
      return services;
    };
    core.application.register({
      id: _constants.APP_UI_ID,
      title: _translations.SOLUTION_NAME,
      appRoute: _constants.APP_PATH,
      category: _public2.DEFAULT_APP_CATEGORIES.security,
      // Initializing app as visible to make sure it appears on the Kibana home page, it is hidden when deepLinks update
      navLinkStatus: _public2.AppNavLinkStatus.visible,
      searchable: true,
      updater$: this.appUpdater$,
      euiIconType: _constants.APP_ICON_SOLUTION,
      mount: async params => {
        // required to show the alert table inside cases
        const {
          alertsTableConfigurationRegistry
        } = plugins.triggersActionsUi;
        const {
          registerAlertsTableConfiguration
        } = await this.lazyRegisterAlertsTableConfiguration();
        registerAlertsTableConfiguration(alertsTableConfigurationRegistry, this.storage);
        const [coreStart, startPlugins] = await core.getStartServices();
        const subPlugins = await this.startSubPlugins(this.storage, coreStart, startPlugins);
        const store = await this.store(coreStart, startPlugins, subPlugins);
        const services = await startServices(params);
        await this.registerActions(store, params.history, services);
        const {
          renderApp
        } = await this.lazyApplicationDependencies();
        const {
          getSubPluginRoutesByCapabilities
        } = await this.lazyHelpersForRoutes();
        return renderApp({
          ...params,
          services,
          store,
          usageCollection: plugins.usageCollection,
          subPluginRoutes: getSubPluginRoutesByCapabilities(subPlugins, coreStart.application.capabilities, services)
        });
      }
    });
    core.application.register({
      id: 'siem',
      appRoute: 'app/siem',
      title: 'SIEM',
      navLinkStatus: 3,
      mount: async params => {
        const [coreStart] = await core.getStartServices();
        const {
          manageOldSiemRoutes
        } = await this.lazyHelpersForRoutes();
        const subscription = this.appUpdater$.subscribe(() => {
          // wait for app initialization to set the links
          manageOldSiemRoutes(coreStart);
          subscription.unsubscribe();
        });
        return () => true;
      }
    });
    return this.contract.getSetupContract();
  }
  start(core, plugins) {
    _services.KibanaServices.init({
      ...core,
      ...plugins,
      kibanaBranch: this.kibanaBranch,
      kibanaVersion: this.kibanaVersion,
      buildFlavor: this.buildFlavor,
      prebuiltRulesPackageVersion: this.prebuiltRulesPackageVersion
    });
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    _use_license.licenseService.start(plugins.licensing.license$);
    if (plugins.fleet) {
      const {
        registerExtension
      } = plugins.fleet;
      const registerOptions = {
        coreStart: core,
        depsStart: plugins,
        services: {
          upsellingService: this.contract.upsellingService
        }
      };
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-edit',
        Component: (0, _lazy_endpoint_policy_edit_extension.getLazyEndpointPolicyEditExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-response',
        Component: (0, _lazy_endpoint_policy_response_extension.getLazyEndpointPolicyResponseExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-generic-errors-list',
        Component: (0, _lazy_endpoint_generic_errors_list.getLazyEndpointGenericErrorsListExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-create',
        Component: (0, _lazy_endpoint_policy_create_extension.getLazyEndpointPolicyCreateExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-create-multi-step',
        Component: _lazy_endpoint_policy_create_multi_step_extension.LazyEndpointPolicyCreateMultiStepExtension
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-detail-custom',
        Component: (0, _lazy_endpoint_package_custom_extension.getLazyEndpointPackageCustomExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-detail-assets',
        Component: _lazy_endpoint_custom_assets_extension.LazyEndpointCustomAssetsExtension
      });
    }

    // Not using await to prevent blocking start execution
    this.registerAppLinks(core, plugins);
    return this.contract.getStartContract();
  }
  stop() {
    this.queryService.stop();
    _use_license.licenseService.stop();
    this.contract.getStopContract();
  }
  lazyHelpersForRoutes() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyHelpersForRoutes" */
    './helpers')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazyApplicationDependencies() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_application_dependencies" */
    './lazy_application_dependencies')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazySubPlugins() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_sub_plugins" */
    './lazy_sub_plugins')));
  }
  lazyRegisterAlertsTableConfiguration() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_register_alerts_table_configuration" */
    './common/lib/triggers_actions_ui/register_alerts_table_configuration')));
  }
  lazyApplicationLinks() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_app_links" */
    './common/links/app_links')));
  }
  lazyActions() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "actions" */
    './actions')));
  }

  /**
   * Lazily instantiated subPlugins. This should be instantiated just once.
   */
  async subPlugins() {
    if (!this._subPlugins) {
      const {
        subPluginClasses
      } = await this.lazySubPlugins();
      this._subPlugins = {
        alerts: new subPluginClasses.Detections(),
        rules: new subPluginClasses.Rules(),
        exceptions: new subPluginClasses.Exceptions(),
        cases: new subPluginClasses.Cases(),
        dashboards: new subPluginClasses.Dashboards(),
        explore: new subPluginClasses.Explore(),
        kubernetes: new subPluginClasses.Kubernetes(),
        overview: new subPluginClasses.Overview(),
        timelines: new subPluginClasses.Timelines(),
        management: new subPluginClasses.Management(),
        cloudDefend: new subPluginClasses.CloudDefend(),
        cloudSecurityPosture: new subPluginClasses.CloudSecurityPosture(),
        threatIntelligence: new subPluginClasses.ThreatIntelligence(),
        entityAnalytics: new subPluginClasses.EntityAnalytics()
      };
    }
    return this._subPlugins;
  }

  /**
   * All started subPlugins.
   */
  async startSubPlugins(storage, core, plugins) {
    const subPlugins = await this.subPlugins();
    return {
      alerts: subPlugins.alerts.start(storage),
      cases: subPlugins.cases.start(),
      cloudDefend: subPlugins.cloudDefend.start(),
      cloudSecurityPosture: subPlugins.cloudSecurityPosture.start(),
      dashboards: subPlugins.dashboards.start(),
      exceptions: subPlugins.exceptions.start(storage),
      explore: subPlugins.explore.start(storage),
      kubernetes: subPlugins.kubernetes.start(),
      management: subPlugins.management.start(core, plugins),
      overview: subPlugins.overview.start(),
      rules: subPlugins.rules.start(storage),
      threatIntelligence: subPlugins.threatIntelligence.start(),
      timelines: subPlugins.timelines.start(),
      entityAnalytics: subPlugins.entityAnalytics.start(this.experimentalFeatures.riskScoringRoutesEnabled)
    };
  }
  /**
   * Lazily instantiate a `SecurityAppStore`. We lazily instantiate this because it requests large dynamic imports. We instantiate it once because each subPlugin needs to share the same reference.
   */
  async store(coreStart, startPlugins, subPlugins) {
    if (!this._store) {
      const {
        createStoreFactory
      } = await this.lazyApplicationDependencies();
      this._store = await createStoreFactory(coreStart, startPlugins, subPlugins, this.storage, this.experimentalFeatures);
    }
    if (startPlugins.timelines) {
      startPlugins.timelines.setTimelineEmbeddedStore(this._store);
    }
    return this._store;
  }
  async registerActions(store, history, services) {
    if (!this._actionsRegistered) {
      const {
        registerActions
      } = await this.lazyActions();
      registerActions(store, history, services);
      this._actionsRegistered = true;
    }
  }

  /**
   * Register deepLinks and appUpdater for all app links, to change deepLinks as needed when licensing changes.
   */
  async registerAppLinks(core, plugins) {
    const {
      links,
      getFilteredLinks
    } = await this.lazyApplicationLinks();
    const {
      license$
    } = plugins.licensing;
    const {
      upsellingService,
      appLinksSwitcher,
      deepLinksFormatter
    } = this.contract;
    (0, _deep_links.registerDeepLinksUpdater)(this.appUpdater$, deepLinksFormatter);
    const baseLinksPermissions = {
      experimentalFeatures: this.experimentalFeatures,
      upselling: upsellingService,
      capabilities: core.application.capabilities
    };
    license$.pipe((0, _rxjs.mergeMap)(async license => {
      const linksPermissions = {
        ...baseLinksPermissions,
        ...(license.type != null && {
          license
        })
      };

      // set initial links to not block rendering
      (0, _links.updateAppLinks)(appLinksSwitcher(links), linksPermissions);

      // set filtered links asynchronously
      const filteredLinks = await getFilteredLinks(core, plugins);
      (0, _links.updateAppLinks)(appLinksSwitcher(filteredLinks), linksPermissions);
    })).subscribe();
  }
}
exports.Plugin = Plugin;