"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentTimelines = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _header = require("./header");
var _with_hover_actions = require("../../../common/components/with_hover_actions");
var _timeline = require("../../../../common/api/timeline");
var _counts = require("./counts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClampText = _styledComponents.default.div`
  /* Clamp text content to 3 lines */
  display: -webkit-box;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: break-word;
`;
const RecentTimelinesItem = /*#__PURE__*/_react.default.memo(({
  timeline,
  onOpenTimeline,
  isLastItem
}) => {
  const handleClick = (0, _react.useCallback)(() => onOpenTimeline({
    duplicate: true,
    timelineId: `${timeline.savedObjectId}`
  }), [onOpenTimeline, timeline.savedObjectId]);
  const render = (0, _react.useCallback)(showHoverContent => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    "data-test-subj": "overview-recent-timelines"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_header.RecentTimelineHeader, {
    onOpenTimeline: onOpenTimeline,
    timeline: timeline
  }), /*#__PURE__*/_react.default.createElement(_counts.RecentTimelineCounts, {
    timeline: timeline
  }), timeline.description && timeline.description.length && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(ClampText, null, timeline.description))), showHoverContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: timeline.timelineType === _timeline.TimelineType.default ? i18n.OPEN_AS_DUPLICATE : i18n.OPEN_AS_DUPLICATE_TEMPLATE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": timeline.timelineType === _timeline.TimelineType.default ? i18n.OPEN_AS_DUPLICATE : i18n.OPEN_AS_DUPLICATE_TEMPLATE,
    "data-test-subj": "open-duplicate",
    isDisabled: timeline.savedObjectId == null,
    iconSize: "s",
    iconType: "copy",
    onClick: handleClick,
    size: "s"
  })))), [handleClick, onOpenTimeline, timeline]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_with_hover_actions.WithHoverActions, {
    render: render
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })));
});
RecentTimelinesItem.displayName = 'RecentTimelinesItem';
const RecentTimelines = /*#__PURE__*/_react.default.memo(({
  noTimelinesMessage,
  onOpenTimeline,
  timelines
}) => {
  const content = (0, _react.useMemo)(() => timelines.map((timeline, index) => /*#__PURE__*/_react.default.createElement(RecentTimelinesItem, {
    key: `${timeline.savedObjectId}-${timeline.title}`,
    timeline: timeline,
    onOpenTimeline: onOpenTimeline,
    isLastItem: index === timelines.length - 1
  })), [onOpenTimeline, timelines]);
  if (timelines.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, noTimelinesMessage));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
});
exports.RecentTimelines = RecentTimelines;
RecentTimelines.displayName = 'RecentTimelines';