"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewNetwork = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _header_section = require("../../../common/components/header_section");
var _kibana = require("../../../common/lib/kibana");
var _manage_query = require("../../../common/components/page/manage_query");
var _overview_network = require("../../containers/overview_network");
var _overview_network_stats = require("../overview_network_stats");
var _link_to = require("../../../common/components/link_to");
var _inspect = require("../../../common/components/inspect");
var _types = require("../../../app/types");
var _links = require("../../../common/components/links");
var _query_toggle = require("../../../common/containers/query_toggle");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewNetworkStatsManage = (0, _manage_query.manageQuery)(_overview_network_stats.OverviewNetworkStats);
const OverviewNetworkComponent = ({
  endDate,
  filterQuery,
  indexNames,
  startDate,
  setQuery
}) => {
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.network);
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_overview_network.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(filterQuery === undefined || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(filterQuery === undefined || !toggleStatus);
  }, [filterQuery, toggleStatus]);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggle on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  const [loading, {
    overviewNetwork,
    id,
    inspect,
    refetch
  }] = (0, _overview_network.useNetworkOverview)({
    endDate,
    filterQuery,
    indexNames,
    startDate,
    skip: querySkip
  });
  const goToNetwork = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.network,
      path: (0, _link_to.getNetworkUrl)(urlSearch)
    });
  }, [navigateToApp, urlSearch]);
  const networkEventsCount = (0, _react.useMemo)(() => (0, _overview_network_stats.getOverviewNetworkStats)(overviewNetwork).reduce((total, stat) => total + stat.count, 0), [overviewNetwork]);
  const formattedNetworkEventsCount = (0, _react.useMemo)(() => (0, _numeral.default)(networkEventsCount).format(defaultNumberFormat), [defaultNumberFormat, networkEventsCount]);
  const networkPageButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    "data-test-subj": "overview-network-go-to-network-page",
    onClick: goToNetwork,
    href: formatUrl((0, _link_to.getNetworkUrl)())
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkAction",
    defaultMessage: "View network"
  })), [goToNetwork, formatUrl]);
  const title = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkTitle",
    defaultMessage: "Network events"
  }), []);
  const subtitle = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(overviewNetwork) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Showing: {formattedNetworkEventsCount} {networkEventsCount, plural, one {event} other {events}}",
    id: "xpack.securitySolution.overview.overviewNetwork.networkSubtitle",
    values: {
      formattedNetworkEventsCount,
      networkEventsCount
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ''), [formattedNetworkEventsCount, networkEventsCount, overviewNetwork]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: toggleStatus
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "overview-network-query"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: _overview_network.ID,
    subtitle: subtitle,
    title: title,
    toggleStatus: toggleStatus,
    toggleQuery: toggleQuery,
    isInspectDisabled: filterQuery === undefined
  }, networkPageButton), toggleStatus && /*#__PURE__*/_react.default.createElement(OverviewNetworkStatsManage, {
    loading: loading,
    data: overviewNetwork,
    id: id,
    inspect: inspect,
    setQuery: setQuery,
    refetch: refetch
  }))));
};
OverviewNetworkComponent.displayName = 'OverviewNetworkComponent';
const OverviewNetwork = /*#__PURE__*/_react.default.memo(OverviewNetworkComponent);
exports.OverviewNetwork = OverviewNetwork;