"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsByDataset = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../../common/constants");
var _translations = require("../../../common/components/events_viewer/translations");
var _redirect_to_hosts = require("../../../common/components/link_to/redirect_to_hosts");
var _matrix_histogram = require("../../../common/components/matrix_histogram");
var _kuery = require("../../../common/lib/kuery");
var _kibana = require("../../../common/lib/kibana");
var _histogram_configurations = require("../../../common/components/events_tab/histogram_configurations");
var _model = require("../../../explore/hosts/store/model");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _types = require("../../../app/types");
var _link_to = require("../../../common/components/link_to");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STACK_BY = 'event.dataset';
const ID = 'eventsByDatasetOverview';
const CHART_HEIGHT = 160;
const getHistogramOption = fieldName => ({
  text: fieldName,
  value: fieldName
});
const StyledLinkButton = (0, _styledComponents.default)(_eui.EuiButton)`
  margin-left: 0;
  @media only screen and (min-width: ${props => props.theme.eui.euiBreakpoints.m}) {
    margin-left: ${({
  theme
}) => theme.eui.euiSizeL};
  }
`;
const EventsByDatasetComponent = ({
  combinedQueries,
  deleteQuery,
  filters,
  from,
  headerChildren,
  indexPattern,
  indexNames,
  runtimeMappings,
  onlyField,
  paddingSize,
  query,
  queryType,
  setAbsoluteRangeDatePickerTarget,
  setQuery,
  showLegend,
  showSpacer = true,
  scopeId,
  sourcererScopeId,
  to,
  toggleTopN,
  hideQueryToggle = false
}) => {
  const uniqueQueryId = (0, _react.useMemo)(() => `${ID}-${queryType}`, [queryType]);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: uniqueQueryId
        });
      }
    };
  }, [deleteQuery, uniqueQueryId]);
  const kibana = (0, _kibana.useKibana)();
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.hosts);
  const {
    navigateToApp
  } = kibana.services.application;
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const goToHostEvents = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.hosts,
      path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.events, urlSearch)
    });
  }, [navigateToApp, urlSearch]);
  const eventsCountViewEventsButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(StyledLinkButton, {
    onClick: goToHostEvents,
    href: formatUrl((0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.events))
  }, i18n.VIEW_EVENTS), [goToHostEvents, formatUrl]);
  const [filterQuery, kqlError] = (0, _react.useMemo)(() => {
    if (combinedQueries == null) {
      return (0, _kuery.convertToBuildEsQuery)({
        config: (0, _common.getEsQueryConfig)(kibana.services.uiSettings),
        indexPattern,
        queries: [query],
        filters
      });
    }
    return [combinedQueries];
  }, [combinedQueries, kibana, indexPattern, query, filters]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: uniqueQueryId,
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const eventsByDatasetHistogramConfigs = (0, _react.useMemo)(() => {
    var _eventsStackByOptions;
    return {
      ..._histogram_configurations.eventsHistogramConfig,
      stackByOptions: onlyField != null ? [getHistogramOption(onlyField)] : _histogram_configurations.eventsHistogramConfig.stackByOptions,
      defaultStackByOption: onlyField != null ? getHistogramOption(onlyField) : (_eventsStackByOptions = _histogram_configurations.eventsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _eventsStackByOptions !== void 0 ? _eventsStackByOptions : _histogram_configurations.eventsStackByOptions[0],
      legendPosition: _charts.Position.Right,
      subtitle: totalCount => `${_translations.SHOWING}: ${(0, _numeral.default)(totalCount).format(defaultNumberFormat)} ${(0, _translations.UNIT)(totalCount)}`,
      titleSize: onlyField == null ? 'm' : 's'
    };
  }, [onlyField, defaultNumberFormat]);
  const headerContent = (0, _react.useMemo)(() => {
    if (onlyField == null || headerChildren != null) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, headerChildren, onlyField == null && eventsCountViewEventsButton);
    } else {
      return null;
    }
  }, [onlyField, headerChildren, eventsCountViewEventsButton]);
  return /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: to,
    filterQuery: filterQuery,
    headerChildren: headerContent,
    id: uniqueQueryId,
    indexNames: indexNames,
    runtimeMappings: runtimeMappings,
    onError: toggleTopN,
    paddingSize: paddingSize,
    setAbsoluteRangeDatePickerTarget: setAbsoluteRangeDatePickerTarget,
    setQuery: setQuery,
    showSpacer: showSpacer,
    showLegend: showLegend,
    skip: filterQuery === undefined,
    startDate: from,
    scopeId: scopeId,
    sourcererScopeId: sourcererScopeId
  }, eventsByDatasetHistogramConfigs, {
    title: onlyField != null ? i18n.TOP(onlyField) : eventsByDatasetHistogramConfigs.title,
    chartHeight: CHART_HEIGHT,
    hideQueryToggle: hideQueryToggle
  }));
};
EventsByDatasetComponent.displayName = 'EventsByDatasetComponent';
const EventsByDataset = /*#__PURE__*/_react.default.memo(EventsByDatasetComponent);
exports.EventsByDataset = EventsByDataset;