"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryProtectionCard = exports.LOCKED_CARD_MEMORY_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _eui = require("@elastic/eui");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _notify_user_option = require("../notify_user_option");
var _detect_prevent_protection_level = require("../detect_prevent_protection_level");
var _protection_setting_card_switch = require("../protection_setting_card_switch");
var _setting_locked_card = require("../setting_locked_card");
var _types = require("../../../../../../../../common/endpoint/types");
var _use_license = require("../../../../../../../common/hooks/use_license");
var _setting_card = require("../setting_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCKED_CARD_MEMORY_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.memory', {
  defaultMessage: 'Memory Threat'
});
exports.LOCKED_CARD_MEMORY_TITLE = LOCKED_CARD_MEMORY_TITLE;
const MEMORY_PROTECTION_OS_VALUES = [_types.PolicyOperatingSystem.windows, _types.PolicyOperatingSystem.mac, _types.PolicyOperatingSystem.linux];
const MemoryProtectionCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const protection = 'memory_protection';
  const selected = (policy && policy.windows[protection].mode) !== _types.ProtectionModes.off;
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.memory', {
    defaultMessage: 'Memory threat protections'
  });
  if (!isProtectionsAllowed) {
    return null;
  }
  if (!isPlatinumPlus) {
    return /*#__PURE__*/_react.default.createElement(_setting_locked_card.SettingLockedCard, {
      title: LOCKED_CARD_MEMORY_TITLE,
      "data-test-subj": getTestId('locked')
    });
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.memory_protection', {
      defaultMessage: 'Memory threat'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.LINUX],
    dataTestSubj: getTestId(),
    selected: selected,
    mode: mode,
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_setting_card_switch.ProtectionSettingCardSwitch, {
      selected: selected,
      policy: policy,
      onChange: onChange,
      mode: mode,
      protection: protection,
      protectionLabel: protectionLabel,
      osList: MEMORY_PROTECTION_OS_VALUES,
      "data-test-subj": getTestId('enableDisableSwitch')
    })
  }, /*#__PURE__*/_react.default.createElement(_detect_prevent_protection_level.DetectPreventProtectionLevel, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: MEMORY_PROTECTION_OS_VALUES,
    "data-test-subj": getTestId('protectionLevel')
  }), /*#__PURE__*/_react.default.createElement(_notify_user_option.NotifyUserOption, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: MEMORY_PROTECTION_OS_VALUES,
    "data-test-subj": getTestId('notifyUser')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
});
exports.MemoryProtectionCard = MemoryProtectionCard;
MemoryProtectionCard.displayName = 'MemoryProtectionCard';