"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinuxEventCollectionCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _i18n = require("@kbn/i18n");
var _event_collection_card = require("../event_collection_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPTIONS = [{
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.file', {
    defaultMessage: 'File'
  }),
  protectionField: 'file'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.network', {
    defaultMessage: 'Network'
  }),
  protectionField: 'network'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.process', {
    defaultMessage: 'Process'
  }),
  protectionField: 'process'
}];
const SUPPLEMENTAL_OPTIONS = [{
  id: 'sessionDataSection',
  title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.title', {
    defaultMessage: 'Session data'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.description', {
    defaultMessage: 'Turn this on to capture the extended process data required for Session View. Session View provides you a visual representation of session and process execution data. Session View data is organized according to the Linux process model to help you investigate process, user, and service activity on your Linux infrastructure.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_dataChecked', {
    defaultMessage: 'Collect session data'
  }),
  uncheckedName: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_dataUnChecked', {
    defaultMessage: 'Do not collect session data'
  }),
  protectionField: 'session_data',
  isDisabled: config => {
    return !config.linux.events.process;
  }
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_ioChecked', {
    defaultMessage: 'Capture terminal output'
  }),
  uncheckedName: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_ioUnChecked', {
    defaultMessage: 'Do not capture terminal output'
  }),
  protectionField: 'tty_io',
  tooltipText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_io.tooltip', {
    defaultMessage: 'Turn this on to collect terminal (tty) output. Terminal output appears in Session View, and you can view it separately to see what commands were executed and how they were typed, provided the terminal is in echo mode. Only works on hosts that support ebpf.'
  }),
  indented: true,
  isDisabled: config => {
    return !config.linux.events.session_data;
  }
}];
const LinuxEventCollectionCard = /*#__PURE__*/(0, _react.memo)(props => {
  const supplementalOptions = (0, _react.useMemo)(() => {
    if (props.mode === 'edit') {
      return SUPPLEMENTAL_OPTIONS;
    }

    // View only mode: remove instructions for session data
    return SUPPLEMENTAL_OPTIONS.map(option => {
      if (option.id === 'sessionDataSection') {
        return {
          ...option,
          description: undefined
        };
      }
      return option;
    });
  }, [props.mode]);
  return /*#__PURE__*/_react.default.createElement(_event_collection_card.EventCollectionCard, (0, _extends2.default)({}, props, {
    os: _securitysolutionUtils.OperatingSystem.LINUX,
    selection: props.policy.linux.events,
    supplementalOptions: supplementalOptions,
    options: OPTIONS
  }));
});
exports.LinuxEventCollectionCard = LinuxEventCollectionCard;
LinuxEventCollectionCard.displayName = 'LinuxEventCollectionCard';