"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _context_menu_item_nav_by_router = require("../../../../../components/context_menu_with_router_support/context_menu_item_nav_by_router");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsMenu = /*#__PURE__*/(0, _react.memo)(({
  hostMetadata
}) => {
  const menuOptions = (0, _hooks.useEndpointActionItems)(hostMetadata);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopoverHandler = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const takeActionItems = (0, _react.useMemo)(() => {
    return menuOptions.map(item => {
      return /*#__PURE__*/_react.default.createElement(_context_menu_item_nav_by_router.ContextMenuItemNavByRouter, (0, _extends2.default)({}, item, {
        onClick: ev => {
          closePopoverHandler();
          if (item.onClick) {
            item.onClick(ev);
          }
        }
      }));
    });
  }, [closePopoverHandler, menuOptions]);
  const takeActionButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "right",
      fill: true,
      iconType: "arrowDown",
      "data-test-subj": "endpointDetailsActionsButton",
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.detailsActions.buttonLabel",
      defaultMessage: "Take action"
    }));
  }, [isPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "endpointDetailsActionsPanel",
    button: takeActionButton,
    isOpen: isPopoverOpen,
    closePopover: closePopoverHandler,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": "endpointDetailsActionsPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: takeActionItems
  }));
});
exports.ActionsMenu = ActionsMenu;
ActionsMenu.displayName = 'ActionMenu';