"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformFailedCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../../../../common/constants");
var _constants2 = require("../../../../../../common/endpoint/constants");
var _link_to_app = require("../../../../../common/components/endpoint/link_to_app");
var _callouts = require("../../../../../common/components/callouts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSFORM_URL = '/data/transform';
const TransformFailedCallout = /*#__PURE__*/(0, _react.memo)(({
  hasNoPolicyData,
  metadataTransformStats
}) => {
  const [showTransformFailedCallout, setShowTransformFailedCallout] = (0, _react.useState)(false);
  const [shouldCheckTransforms, setShouldCheckTransforms] = (0, _react.useState)(true);
  const {
    services
  } = (0, _kibana.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    // if no endpoint policy, skip transform check
    if (!shouldCheckTransforms || hasNoPolicyData) {
      return;
    }
    dispatch({
      type: 'loadMetadataTransformStats'
    });
    setShouldCheckTransforms(false);
  }, [dispatch, hasNoPolicyData, shouldCheckTransforms]);
  (0, _react.useEffect)(() => {
    const hasFailure = metadataTransformStats.some(transform => _constants.WARNING_TRANSFORM_STATES.has(transform === null || transform === void 0 ? void 0 : transform.state));
    setShowTransformFailedCallout(hasFailure);
  }, [metadataTransformStats]);
  const closeTransformFailedCallout = (0, _react.useCallback)(() => {
    setShowTransformFailedCallout(false);
  }, []);
  const failingTransformIds = (0, _react.useMemo)(() => metadataTransformStats.reduce((acc, currentValue) => {
    if (_constants.WARNING_TRANSFORM_STATES.has(currentValue.state)) {
      acc.push(currentValue.id);
    }
    return acc;
  }, []).join(', '), [metadataTransformStats]);
  const calloutDescription = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.transformFailed.message",
    defaultMessage: "A required transform, {transformId}, is currently failing. Most of the time this can be fixed by {transformsPage}. For additional help, please visit the {docsPage}",
    values: {
      transformId: failingTransformIds || _constants2.metadataTransformPrefix,
      transformsPage: /*#__PURE__*/_react.default.createElement(_link_to_app.LinkToApp, {
        "data-test-subj": "failed-transform-restart-link",
        appId: "management",
        appPath: TRANSFORM_URL
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.list.transformFailed.restartLink",
        defaultMessage: "restarting the transform"
      })),
      docsPage: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "failed-transform-docs-link",
        href: services.docLinks.links.endpoints.troubleshooting,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.list.transformFailed.docsLink",
        defaultMessage: "troubleshooting documentation"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), [failingTransformIds, services.docLinks.links.endpoints.troubleshooting]);
  if (!showTransformFailedCallout) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callouts.CallOut, {
    message: {
      id: 'endpoints-list-transform-failed',
      type: 'warning',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.transformFailed.title', {
        defaultMessage: 'Required transform failed'
      }),
      description: calloutDescription
    },
    dismissButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.transformFailed.dismiss', {
      defaultMessage: 'Dismiss'
    }),
    onDismiss: closeTransformFailedCallout,
    showDismissButton: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
});
exports.TransformFailedCallout = TransformFailedCallout;
TransformFailedCallout.displayName = 'TransformFailedCallout';