"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlocklistsApiClient = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _exception_list_items = require("../../../../common/utils/exception_list_items");
var _exceptions_list_api_client = require("../../../services/exceptions_list/exceptions_list_api_client");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function readTransform(item) {
  return {
    ...item,
    entries: (0, _exception_list_items.entriesToConditionEntries)(item.entries)
  };
}
function writeTransform(item) {
  return {
    ...item,
    entries: (0, _exception_list_items.conditionEntriesToEntries)(item.entries)
  };
}

/**
 * Blocklist exceptions Api client class using ExceptionsListApiClient as base class
 * It follows the Singleton pattern.
 * Please, use the getInstance method instead of creating a new instance when using this implementation.
 */
class BlocklistsApiClient extends _exceptions_list_api_client.ExceptionsListApiClient {
  constructor(http) {
    super(http, _securitysolutionListConstants.ENDPOINT_BLOCKLISTS_LIST_ID, _constants.BLOCKLISTS_LIST_DEFINITION, readTransform, writeTransform);
  }
  static getInstance(http) {
    return super.getInstance(http, _securitysolutionListConstants.ENDPOINT_BLOCKLISTS_LIST_ID, _constants.BLOCKLISTS_LIST_DEFINITION, readTransform, writeTransform);
  }
}
exports.BlocklistsApiClient = BlocklistsApiClient;