"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetFileActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_send_get_file_request = require("../../../hooks/response_actions/use_send_get_file_request");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _response_action_file_download_link = require("../../response_action_file_download_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetFileActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3, _command$commandDefin4;
  const {
    canWriteFileOperations
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const actionCreator = (0, _use_send_get_file_request.useSendGetFileRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2;
    const endpointId = (_command$commandDefin = command.commandDefinition) === null || _command$commandDefin === void 0 ? void 0 : (_command$commandDefin2 = _command$commandDefin.meta) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.endpointId;
    const {
      path,
      comment
    } = command.args.args;
    return endpointId ? {
      endpoint_ids: [endpointId],
      comment: comment === null || comment === void 0 ? void 0 : comment[0],
      parameters: {
        path: path[0]
      }
    } : undefined;
  }, [command.args.args, (_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : (_command$commandDefin4 = _command$commandDefin3.meta) === null || _command$commandDefin4 === void 0 ? void 0 : _command$commandDefin4.endpointId]);
  const {
    result,
    actionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'getFile',
    pendingMessage: _i18n.i18n.translate('xpack.securitySolution.getFileAction.pendingMessage', {
      defaultMessage: 'Retrieving the file from host.'
    })
  });
  if (actionDetails !== null && actionDetails !== void 0 && actionDetails.isCompleted && actionDetails.wasSuccessful) {
    return /*#__PURE__*/_react.default.createElement(ResultComponent, {
      showAs: "success",
      "data-test-subj": "getFileSuccess",
      title: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getFileAction.successTitle', {
        defaultMessage: 'File retrieved from the host.'
      })
    }, /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
      action: actionDetails,
      canAccessFileDownloadLink: canWriteFileOperations
    }));
  }
  return result;
});
exports.GetFileActionResult = GetFileActionResult;
GetFileActionResult.displayName = 'GetFileActionResult';