"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _routing = require("../common/routing");
var _use_navigate_by_router_event_handler = require("../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _hooks = require("../../common/lib/kibana/hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A policy link (to details) that first checks to see if the policy id exists against
 * the `nonExistingPolicies` value in the store. If it does not exist, then regular
 * text is returned.
 */
const EndpointPolicyLink = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  backLink,
  children,
  missingPolicies = {},
  ...otherProps
}) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const {
    toRoutePath,
    toRouteUrl
  } = (0, _react.useMemo)(() => {
    const path = policyId ? (0, _routing.getPolicyDetailPath)(policyId) : '';
    return {
      toRoutePath: backLink ? {
        pathname: path,
        state: {
          backLink
        }
      } : path,
      toRouteUrl: getAppUrl({
        path
      })
    };
  }, [policyId, getAppUrl, backLink]);
  const clickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(toRoutePath);
  if (!policyId || missingPolicies[policyId]) {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: otherProps.className,
      "data-test-subj": otherProps['data-test-subj']
    }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      className: "eui-textNoWrap"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "warning",
      color: "warning"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyNotFound",
      defaultMessage: "Policy not found!"
    })));
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      href: toRouteUrl,
      onClick: clickHandler
    }, otherProps), children)
  );
});
exports.EndpointPolicyLink = EndpointPolicyLink;
EndpointPolicyLink.displayName = 'EndpointPolicyLink';