"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenuItemNavByRouter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_navigate_to_app_event_handler = require("../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiContextMenuItem = (0, _styledComponents.default)(_eui.EuiContextMenuItem)`
  .additional-info {
    display: none;
    max-width: 50%;
  }
  &:hover {
    .additional-info {
      display: block !important;
    }
  }
`;
const StyledEuiFlexItem = (0, _styledComponents.default)('div')`
  max-width: 50%;
  padding-right: ${props => props.theme.eui.euiSizeS};
`;
const StyledEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  padding: ${props => props.theme.eui.euiSizeM};
  line-height: ${props => props.theme.eui.euiFontSizeM};
`;

/**
 * Just like `EuiContextMenuItem`, but allows for additional props to be defined which will
 * allow navigation to a URL path via React Router
 */

const ContextMenuItemNavByRouter = /*#__PURE__*/(0, _react.memo)(({
  navigateAppId,
  navigateOptions,
  onClick,
  textTruncate,
  hoverInfo,
  children,
  isNavigationDisabled = false,
  ...otherMenuItemProps
}) => {
  const handleOnClickViaNavigateToApp = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(navigateAppId !== null && navigateAppId !== void 0 ? navigateAppId : '', {
    ...navigateOptions,
    onClick
  });
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(otherMenuItemProps['data-test-subj']);
  const hoverComponentInstance = (0, _react.useMemo)(() => {
    // If the `hoverInfo` is not an object (ex. text, number), then auto-add the text truncation className.
    // Adding this when the `hoverInfo` is a react component could cause issue, thus in htose cases, we
    // assume the componet will handle how the data is truncated (if applicable)
    const cssClassNames = `additional-info ${'object' !== typeof hoverInfo ? 'eui-textTruncate' : ''}`;
    return hoverInfo ? /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
      className: cssClassNames
    }, hoverInfo) : null;
  }, [hoverInfo]);
  const content = textTruncate ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: "eui-textTruncate",
    "data-test-subj": getTestId('truncateWrapper')
  }, 'string' === typeof children ? {
    title: children
  } : {}), children), hoverComponentInstance) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), hoverComponentInstance);
  return isNavigationDisabled ? /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "s",
    className: "eui-textTruncate",
    "data-test-subj": otherMenuItemProps['data-test-subj']
  }, content) : /*#__PURE__*/_react.default.createElement(StyledEuiContextMenuItem, (0, _extends2.default)({}, otherMenuItemProps, {
    onClick: navigateAppId ? handleOnClickViaNavigateToApp : onClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, content));
});
exports.ContextMenuItemNavByRouter = ContextMenuItemNavByRouter;
ContextMenuItemNavByRouter.displayName = 'EuiContextMenuItemNavByRouter';