"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryOutput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _command_execution_output = require("./command_execution_output");
var _use_command_history = require("../hooks/state_selectors/use_command_history");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _history_item = require("./history_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HistoryOutput = /*#__PURE__*/(0, _react.memo)(commonProps => {
  const historyItems = (0, _use_command_history.useCommandHistory)();
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const historyBody = (0, _react.useMemo)(() => {
    return historyItems.map(historyItem => {
      return /*#__PURE__*/_react.default.createElement(_history_item.HistoryItem, {
        key: historyItem.id
      }, /*#__PURE__*/_react.default.createElement(_command_execution_output.CommandExecutionOutput, {
        item: historyItem
      }));
    });
  }, [historyItems]);

  // Anytime we add a new item to the history
  // scroll down so that command input remains visible
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'scrollDown'
    });
  }, [dispatch, historyItems.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    "data-test-subj": getTestId('historyOutput')
  }, commonProps, {
    wrap: true,
    direction: "column",
    alignItems: "stretch",
    responsive: false,
    gutterSize: "none"
  }), historyBody);
});
exports.HistoryOutput = HistoryOutput;
HistoryOutput.displayName = 'HistoryOutput';