"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandInputClearHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommandInputClearHistory = /*#__PURE__*/(0, _react.memo)(() => {
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const handleClearInputHistory = (0, _react.useCallback)(() => {
    setShowConfirmModal(true);
  }, []);
  const handleConfirmModalCancel = (0, _react.useCallback)(() => {
    setShowConfirmModal(false);
  }, []);
  const handleConfirmModalConfirm = (0, _react.useCallback)(() => {
    dispatch({
      type: 'clearInputHistoryState'
    });
    setShowConfirmModal(false);
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConfirmModal && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.securitySolution.commandInputClearHistory.confirmTitle', {
      defaultMessage: 'Clear input history'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.securitySolution.commandInputClearHistory.confirmCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.securitySolution.commandInputClearHistory.confirmSubmitButton', {
      defaultMessage: 'Clear'
    }),
    buttonColor: "danger",
    onCancel: handleConfirmModalCancel,
    onConfirm: handleConfirmModalConfirm
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.commandInputClearHistory.confirmMessage",
    defaultMessage: "This action cannot be undone. Are you sure you wish to continue?"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexEnd",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    tabIndex: -1,
    onClick: handleClearInputHistory,
    disabled: showConfirmModal,
    "data-test-subj": getTestId('clearInputHistoryButton')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.commandInputClearHistory.clearHistoryButtonLabel",
    defaultMessage: "Clear input history"
  })))));
});
exports.CommandInputClearHistory = CommandInputClearHistory;
CommandInputClearHistory.displayName = 'CommandInputClearHistory';