"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgumentSelectorWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_command_argument_state = require("../../../hooks/state_selectors/use_with_command_argument_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ArgumentSelectorWrapperContainer = _styledComponents.default.span`
  border: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThin};
  border-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadiusSmall};
  overflow: hidden;
  user-select: none;

  .flexGroup {
    align-items: stretch;
  }

  .selectorContainer {
    padding: 0 ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
    max-width: 25vw;
    display: flex;
    align-items: center;
    height: 100%;
  }

  .argNameContainer {
    background-color: ${({
  theme: {
    eui
  }
}) => eui.euiFormInputGroupLabelBackground};
  }

  .argName {
    padding-left: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
    height: 100%;
    display: flex;
    align-items: center;
    white-space: nowrap;
  }
`;

// Type to ensure that `SelectorComponent` is defined

/**
 * handles displaying a custom argument value selector and manages its state
 */
const ArgumentSelectorWrapper = /*#__PURE__*/(0, _react.memo)(({
  argName,
  argIndex,
  argDefinition: {
    SelectorComponent
  }
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const {
    valueText,
    value,
    store
  } = (0, _use_with_command_argument_state.useWithCommandArgumentState)(argName, argIndex);
  const handleSelectorComponentOnChange = (0, _react.useCallback)(updates => {
    dispatch({
      type: 'updateInputCommandArgState',
      payload: {
        name: argName,
        instance: argIndex,
        state: updates
      }
    });
  }, [argIndex, argName, dispatch]);
  return /*#__PURE__*/_react.default.createElement(ArgumentSelectorWrapperContainer, {
    className: "eui-displayInlineBlock"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "flexGroup",
    responsive: false,
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "argNameContainer"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "argName"
  }, /*#__PURE__*/_react.default.createElement("span", null, `--${argName}=`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "selectorContainer noThemeOverrides eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(SelectorComponent, {
    value: value,
    valueText: valueText !== null && valueText !== void 0 ? valueText : '',
    argName: argName,
    argIndex: argIndex,
    store: store,
    onChange: handleSelectorComponentOnChange
  })))));
});
exports.ArgumentSelectorWrapper = ArgumentSelectorWrapper;
ArgumentSelectorWrapper.displayName = 'ArgumentSelectorWrapper';