"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandExecutionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _console_text = require("./console_text");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMAND_EXECUTION_RESULT_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.commandExecutionResult.successTitle', {
  defaultMessage: 'Action completed.'
});
const COMMAND_EXECUTION_RESULT_FAILURE_TITLE = _i18n.i18n.translate('xpack.securitySolution.commandExecutionResult.failureTitle', {
  defaultMessage: 'Action failed.'
});
const COMMAND_EXECUTION_RESULT_PENDING = _i18n.i18n.translate('xpack.securitySolution.commandExecutionResult.pending', {
  defaultMessage: 'Action pending.'
});
/**
 * A component that can be used by consumers of the Console to format the result of a command.
 * Applies consistent structure, colors and formatting, and includes ability to set a title and
 * whether the result is a success or failure.
 */
const CommandExecutionResult = /*#__PURE__*/(0, _react.memo)(({
  showAs = 'success',
  title,
  showTitle = true,
  'data-test-subj': dataTestSubj,
  className,
  children
}) => {
  const consoleDataTestSubj = (0, _use_data_test_subj.useDataTestSubj)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : consoleDataTestSubj);
  const panelClassName = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'eui-displayInlineBlock': showAs === 'pending',
      // This class name (font-family-code) is a utility class defined in `Console.tsx`
      'font-family-code': true,
      [className || '_']: Boolean(className)
    });
  }, [className, showAs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none",
    borderRadius: "none",
    color: "transparent",
    className: panelClassName,
    "data-test-subj": dataTestSubj ? dataTestSubj : getTestId('commandExecutionResult')
  }, showAs === 'pending' ? /*#__PURE__*/_react.default.createElement(_console_text.ConsoleText, null, children !== null && children !== void 0 ? children : COMMAND_EXECUTION_RESULT_PENDING) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_console_text.ConsoleText, {
    color: showAs === 'success' ? 'success' : 'danger'
  }, title ? title : showAs === 'success' ? COMMAND_EXECUTION_RESULT_SUCCESS_TITLE : COMMAND_EXECUTION_RESULT_FAILURE_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), children));
});
exports.CommandExecutionResult = CommandExecutionResult;
CommandExecutionResult.displayName = 'CommandExecutionResult';