"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../common/store/inputs/constants");
var _page_wrapper = require("../../common/components/page_wrapper");
var _kibana = require("../../common/lib/kibana");
var _constants2 = require("../../../common/constants");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _filters_global = require("../../common/components/filters_global");
var _search_bar = require("../../common/components/search_bar");
var _helpers = require("../../timelines/components/timeline/helpers");
var _store = require("../../common/store");
var _use_full_screen = require("../../common/containers/use_full_screen");
var _sourcerer = require("../../common/containers/sourcerer");
var _use_global_time = require("../../common/containers/use_global_time");
var _use_selector = require("../../common/hooks/use_selector");
var _kuery = require("../../common/lib/kuery");
var _use_invalid_filter_query = require("../../common/hooks/use_invalid_filter_query");
var _sessions_viewer = require("../../common/components/sessions_viewer");
var _constants3 = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KubernetesContainer = /*#__PURE__*/_react.default.memo(() => {
  const {
    kubernetesSecurity,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    indexPattern,
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const [filterQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [query],
    filters
  }), [filters, indexPattern, uiSettings, query]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: 'kubernetesQuery',
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const renderSessionsView = (0, _react.useCallback)(sessionsFilterQuery => /*#__PURE__*/_react.default.createElement(_sessions_viewer.SessionsView, {
    tableId: _securitysolutionDataTable.TableId.kubernetesPageSessions,
    endDate: to,
    pageFilters: [],
    startDate: from,
    filterQuery: sessionsFilterQuery,
    columns: _constants3.kubernetesSessionsHeaders,
    defaultColumns: _constants3.kubernetesSessionsHeaders
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: true
  }, kubernetesSecurity.getKubernetesPage({
    filter: /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
      show: (0, _helpers.showGlobalFilters)({
        globalFullScreen,
        graphEventId: undefined
      })
    }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
      id: _constants.InputsModelId.global,
      sourcererDataView: sourcererDataView
    })),
    indexPattern,
    globalFilter: {
      filterQuery,
      startDate: from,
      endDate: to
    },
    renderSessionsView
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants2.SecurityPageName.kubernetes
  }));
});
exports.KubernetesContainer = KubernetesContainer;
KubernetesContainer.displayName = 'KubernetesContainer';