"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kubernetesSessionsHeaders = void 0;
var _default_headers = require("../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../timelines/components/timeline/body/constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kubernetesSessionsHeaders = [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.start',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH,
  display: _translations.COLUMN_SESSION_START
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.executable',
  display: _translations.COLUMN_EXECUTABLE
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.user.id',
  display: _translations.COLUMN_ENTRY_USER
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.interactive',
  display: _translations.COLUMN_INTERACTIVE
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'cloud.instance.name',
  display: _translations.COLUMN_NODE
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'orchestrator.resource.name',
  display: _translations.COLUMN_POD
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'container.name',
  display: _translations.COLUMN_CONTAINER
}];
exports.kubernetesSessionsHeaders = kubernetesSessionsHeaders;