"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsByAncestry = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _investigate_in_resolver = require("../../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_license = require("../../../../common/hooks/use_license");
var _field_names = require("../constants/field_names");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if the user has at least platinum privilege, and if the document has ancestry data
 */
const useShowRelatedAlertsByAncestry = ({
  getFieldsData,
  dataAsNestedObject,
  dataFormattedForFieldBrowser,
  eventId,
  isPreview
}) => {
  var _getField;
  const isRelatedAlertsByProcessAncestryEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('insightsRelatedAlertsByProcessAncestry');
  const hasProcessEntityInfo = (0, _investigate_in_resolver.useIsInvestigateInResolverActionEnabled)(dataAsNestedObject);
  const ancestorId = (_getField = (0, _utils.getField)(getFieldsData(_field_names.ANCESTOR_ID))) !== null && _getField !== void 0 ? _getField : '';
  const documentId = isPreview ? ancestorId : eventId;
  // can't use getFieldsData here as the kibana.alert.rule.parameters is different and can be nested
  const originalDocumentIndex = (0, _react.useMemo)(() => (0, _fp.find)({
    category: 'kibana',
    field: _field_names.RULE_PARAMETERS_INDEX
  }, dataFormattedForFieldBrowser), [dataFormattedForFieldBrowser]);
  const hasAtLeastPlatinum = (0, _use_license.useLicense)().isPlatinumPlus();
  const show = isRelatedAlertsByProcessAncestryEnabled && hasProcessEntityInfo && originalDocumentIndex != null && hasAtLeastPlatinum;
  return {
    show,
    documentId,
    ...(originalDocumentIndex && originalDocumentIndex.values && {
      indices: originalDocumentIndex.values
    })
  };
};
exports.useShowRelatedAlertsByAncestry = useShowRelatedAlertsByAncestry;