"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldFromBrowserField = exports.getColumns = exports.TableTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _field_value_cell = require("../../../../common/components/event_details/table/field_value_cell");
var _field_name_cell = require("../../../../common/components/event_details/table/field_name_cell");
var _cell_actions = require("../components/cell_actions");
var i18n = _interopRequireWildcard(require("../../../../common/components/event_details/translations"));
var _context = require("../context");
var _event_fields_browser = require("../../../../common/components/event_details/event_fields_browser");
var _types = require("../../../../../common/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldFromBrowserField = (0, _memoizeOne.default)((keys, browserFields) => (0, _lodash.get)(browserFields, keys), (newArgs, lastArgs) => newArgs[0].join() === lastArgs[0].join());
exports.getFieldFromBrowserField = getFieldFromBrowserField;
const getColumns = ({
  browserFields,
  eventId,
  contextId,
  scopeId,
  getLinkValue,
  isDraggable
}) => [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.FIELD)),
  width: '30%',
  render: (field, data) => {
    return /*#__PURE__*/_react.default.createElement(_field_name_cell.FieldNameCell, {
      data: data,
      field: field,
      fieldMapping: undefined
    });
  }
}, {
  field: 'values',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.VALUE)),
  width: '70%',
  render: (values, data) => {
    const fieldFromBrowserField = getFieldFromBrowserField([data.category, 'fields', data.field], browserFields);
    return /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: data.field,
      value: values,
      isObjectArray: data.isObjectArray
    }, /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
      contextId: contextId,
      data: data,
      eventId: eventId,
      fieldFromBrowserField: fieldFromBrowserField,
      getLinkValue: getLinkValue,
      isDraggable: isDraggable,
      values: values
    }));
  }
}];

/**
 * Table view displayed in the document details expandable flyout right section
 */
exports.getColumns = getColumns;
const TableTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    browserFields,
    dataFormattedForFieldBrowser,
    eventId,
    scopeId
  } = (0, _context.useRightPanelContext)();
  return /*#__PURE__*/_react.default.createElement(_event_fields_browser.EventFieldsBrowser, {
    browserFields: browserFields,
    data: dataFormattedForFieldBrowser,
    eventId: eventId,
    isDraggable: false,
    timelineTabType: _types.TimelineTabs.query,
    scopeId: scopeId,
    isReadOnly: false,
    columnsProvider: getColumns
  });
});
exports.TableTab = TableTab;
TableTab.displayName = 'TableTab';