"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var _flyout = require("../../../timelines/components/side_panel/event_details/flyout");
var _context = require("./context");
var _use_host_isolation_tools = require("../../../timelines/components/side_panel/event_details/use_host_isolation_tools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContainerDiv = (0, _styledComponents.default)('div')`
  .side-panel-flyout-footer {
    padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingMedium};
  }
`;
/**
 *
 */
const PanelFooter = ({
  isPreview
}) => {
  const {
    closeFlyout,
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    dataFormattedForFieldBrowser,
    dataAsNestedObject,
    refetchFlyoutData,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    isHostIsolationPanelOpen,
    showHostIsolationPanel
  } = (0, _use_host_isolation_tools.useHostIsolationTools)();
  const showHostIsolationPanelCallback = (0, _react.useCallback)(action => {
    showHostIsolationPanel(action);
    openRightPanel({
      id: 'document-details-isolate-host',
      params: {
        id: eventId,
        indexName,
        scopeId,
        isolateAction: action
      }
    });
  }, [eventId, indexName, openRightPanel, scopeId, showHostIsolationPanel]);
  return !isPreview ? /*#__PURE__*/_react.default.createElement(ContainerDiv, null, /*#__PURE__*/_react.default.createElement(_flyout.FlyoutFooter, {
    detailsData: dataFormattedForFieldBrowser,
    detailsEcsData: dataAsNestedObject,
    handleOnEventClosed: closeFlyout,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    isReadOnly: false,
    loadingEventDetails: false,
    onAddIsolationStatusClick: showHostIsolationPanelCallback,
    scopeId: scopeId,
    refetchFlyoutData: refetchFlyoutData
  })) : null;
};
exports.PanelFooter = PanelFooter;