"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelligenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_fetch_threat_intelligence = require("../hooks/use_fetch_threat_intelligence");
var _insights_summary_row = require("./insights_summary_row");
var _context = require("../context");
var _test_ids = require("./test_ids");
var _left = require("../../left");
var _threat_intelligence_details = require("../../left/components/threat_intelligence_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Threat intelligence section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const ThreatIntelligenceOverview = () => {
  const {
    eventId,
    indexName,
    scopeId,
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const goToThreatIntelligenceTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    loading,
    threatMatchesCount,
    threatEnrichmentsCount
  } = (0, _use_fetch_threat_intelligence.useFetchThreatIntelligence)({
    dataFormattedForFieldBrowser
  });
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatIntelligenceTitle",
        defaultMessage: "Threat intelligence"
      }),
      link: {
        callback: goToThreatIntelligenceTab,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatIntelligenceTooltip",
          defaultMessage: "Show all threat intelligence"
        })
      },
      iconType: 'arrowStart'
    },
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID,
    content: {
      loading
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    "data-test-subj": `${_test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID}Container`
  }, /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    icon: 'warning',
    value: threatMatchesCount,
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatMatchDescription",
      defaultMessage: "threat {count, plural, one {match} other {matches}} detected",
      values: {
        count: threatMatchesCount
      }
    }),
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    icon: 'warning',
    value: threatEnrichmentsCount,
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatEnrichmentDescription",
      defaultMessage: "{count, plural, one {field} other {fields}} enriched with threat intelligence",
      values: {
        count: threatEnrichmentsCount
      }
    }),
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID
  })));
};
exports.ThreatIntelligenceOverview = ThreatIntelligenceOverview;
ThreatIntelligenceOverview.displayName = 'ThreatIntelligenceOverview';