"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionPreview = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _formatted_date = require("../../../../common/components/formatted_date");
var _use_process_data = require("../hooks/use_process_data");
var _formatted_field_helpers = require("../../../../timelines/components/timeline/body/renderers/formatted_field_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * One-off helper to make sure that inline values are rendered consistently
 */
const ValueContainer = ({
  text,
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement("span", null, text), "\xA0"), children);

/**
 * Renders session preview under Visualizations section in the flyout right EuiPanel
 */
const SessionPreview = () => {
  const {
    eventId,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    processName,
    userName,
    startAt,
    ruleName,
    ruleId,
    workdir,
    command
  } = (0, _use_process_data.useProcessData)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const emphasisStyles = (0, _react.useMemo)(() => ({
    fontWeight: euiTheme.font.weight.bold
  }), [euiTheme.font.weight.bold]);
  const processNameFragment = (0, _react.useMemo)(() => {
    return processName && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.processDescription",
        defaultMessage: "started"
      })
    }, /*#__PURE__*/_react.default.createElement("span", {
      style: emphasisStyles
    }, processName));
  }, [emphasisStyles, processName]);
  const timeFragment = (0, _react.useMemo)(() => {
    return startAt && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.timeDescription",
        defaultMessage: "at"
      })
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(startAt)
    }));
  }, [startAt]);
  const ruleFragment = (0, _react.useMemo)(() => {
    return ruleName && ruleId && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.ruleDescription",
        defaultMessage: "with rule"
      })
    }, /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
      contextId: scopeId,
      eventId: eventId,
      fieldName: _constants.SIGNAL_RULE_NAME_FIELD_NAME,
      fieldType: 'string',
      isAggregatable: false,
      isDraggable: false,
      linkValue: !isPreview ? ruleId : null,
      value: ruleName
    }));
  }, [ruleName, ruleId, scopeId, eventId, isPreview]);
  const commandFragment = (0, _react.useMemo)(() => {
    return command && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.commandDescription",
        defaultMessage: "by"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, workdir, " ", command));
  }, [command, workdir]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        line-height: 1.5;
      `,
    "data-test-subj": _test_ids.SESSION_PREVIEW_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(ValueContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user"
  }), "\xA0", /*#__PURE__*/_react.default.createElement("span", {
    style: emphasisStyles
  }, userName)), processNameFragment, timeFragment, ruleFragment, commandFragment);
};
exports.SessionPreview = SessionPreview;