"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_url_state = require("../../../../common/hooks/use_url_state");
var _copy_to_clipboard = require("../../../shared/utils/copy_to_clipboard");
var _use_get_alert_details_flyout_link = require("../../../../timelines/components/side_panel/event_details/use_get_alert_details_flyout_link");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _use_assistant = require("../hooks/use_assistant");
var _translations = require("../../../../common/components/event_details/translations");
var _context = require("../context");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Actions displayed in the header menu in the right section of alerts flyout
 */
const HeaderActions = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    eventId,
    indexName
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    timestamp
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const alertDetailsLink = (0, _use_get_alert_details_flyout_link.useGetAlertDetailsFlyoutLink)({
    _id: eventId,
    _index: indexName,
    timestamp
  });
  const showShareAlertButton = isAlert && alertDetailsLink;
  const modifier = value => {
    const query = new URLSearchParams(window.location.search);
    return `${value}&${_use_url_state.URL_PARAM_KEY.eventFlyout}=${query.get(_use_url_state.URL_PARAM_KEY.eventFlyout)}`;
  };
  const {
    showAssistant,
    promptContextId
  } = (0, _use_assistant.useAssistant)({
    dataFormattedForFieldBrowser,
    isAlert
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, showAssistant && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatById, {
    conversationId: isAlert ? _translations.ALERT_SUMMARY_CONVERSATION_ID : _translations.EVENT_SUMMARY_CONVERSATION_ID,
    promptContextId: promptContextId,
    iconOnly: true
  })), showShareAlertButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.shareButtonToolTip', {
      defaultMessage: 'Share alert'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: alertDetailsLink
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: 'share',
    color: 'text',
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.shareButtonAriaLabel', {
      defaultMessage: 'Share alert'
    }),
    "data-test-subj": _test_ids.SHARE_BUTTON_TEST_ID,
    onClick: () => (0, _copy_to_clipboard.copyFunction)(copy, alertDetailsLink, modifier),
    onKeyDown: () => (0, _copy_to_clipboard.copyFunction)(copy, alertDetailsLink, modifier)
  })))));
});
exports.HeaderActions = HeaderActions;
HeaderActions.displayName = 'HeaderActions';