"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("../context");
var _formatted_field_helpers = require("../../../../timelines/components/timeline/body/renderers/formatted_field_helpers");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _flyout_footer = require("../../../shared/components/flyout_footer");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Footer in rule preview panel
 */
const RulePreviewFooter = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    scopeId,
    eventId,
    ruleId
  } = (0, _context.usePreviewPanelContext)();
  return ruleId ? /*#__PURE__*/_react.default.createElement(_flyout_footer.FlyoutFooter, {
    "data-test-subj": _test_ids.RULE_PREVIEW_FOOTER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
    contextId: scopeId,
    eventId: eventId,
    fieldName: _constants.SIGNAL_RULE_NAME_FIELD_NAME,
    fieldType: 'string',
    isAggregatable: false,
    isDraggable: false,
    linkValue: ruleId,
    value: _i18n.i18n.translate('xpack.securitySolution.flyout.preview.rule.viewDetailsLabel', {
      defaultMessage: 'Show rule details'
    }),
    openInNewTab: true
  })))) : null;
});
exports.RulePreviewFooter = RulePreviewFooter;
RulePreviewFooter.displayName = 'RulePreviewFooter';