"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useThreatIntelligenceDetails = void 0;
var _react = require("react");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _helpers2 = require("../../../../common/components/event_details/cti_details/helpers");
var _constants = require("../../../../../common/constants");
var _model = require("../../../../common/store/sourcerer/model");
var _event_enrichment = require("../../../../common/containers/cti/event_enrichment");
var _details = require("../../../../timelines/containers/details");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_route_spy = require("../../../../common/utils/route/use_route_spy");
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A hook that returns data necessary strictly to render Threat Intel Insights.
 * Reusing a bunch of hooks scattered across kibana, it makes it easier to mock the data layer
 * for component testing.
 */
const useThreatIntelligenceDetails = () => {
  const {
    indexName,
    eventId
  } = (0, _context.useLeftPanelContext)();
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const sourcererScope = pageName === _constants.SecurityPageName.detections ? _model.SourcererScopeName.detections : _model.SourcererScopeName.default;
  const sourcererDataView = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const [isEventDataLoading, eventData] = (0, _details.useTimelineEventsDetails)({
    indexName,
    eventId,
    runtimeMappings: sourcererDataView.runtimeMappings,
    skip: !eventId
  });
  const {
    isAlert
  } = (0, _helpers.useBasicDataFromDetailsData)(eventData);
  const data = (0, _react.useMemo)(() => eventData || [], [eventData]);
  const eventFields = (0, _react.useMemo)(() => (0, _helpers2.getEnrichmentFields)(data || []), [data]);
  const {
    result: enrichmentsResponse,
    loading: isEnrichmentsLoading,
    setRange,
    range
  } = (0, _event_enrichment.useInvestigationTimeEnrichment)(eventFields);
  const existingEnrichments = (0, _react.useMemo)(() => isAlert ? (0, _helpers2.parseExistingEnrichments)(data).map(enrichmentData => (0, _helpers2.timelineDataToEnrichment)(enrichmentData)) : [], [data, isAlert]);
  const allEnrichments = (0, _react.useMemo)(() => {
    if (isEnrichmentsLoading || !(enrichmentsResponse !== null && enrichmentsResponse !== void 0 && enrichmentsResponse.enrichments)) {
      return existingEnrichments;
    }
    return (0, _helpers2.filterDuplicateEnrichments)([...existingEnrichments, ...enrichmentsResponse.enrichments]);
  }, [isEnrichmentsLoading, enrichmentsResponse, existingEnrichments]);
  const isLoading = isEnrichmentsLoading || isEventDataLoading;
  return {
    enrichments: allEnrichments,
    eventFields,
    isEnrichmentsLoading,
    isEventDataLoading,
    isLoading,
    range,
    setRange
  };
};
exports.useThreatIntelligenceDetails = useThreatIntelligenceDetails;