"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _osquery_tab = require("../../../../common/components/event_details/osquery_tab");
var _response_actions_view = require("../../../../common/components/event_details/response_actions_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExtendedFlyoutWrapper = _styledComponents.default.div`
 figure {
  background-color: white
`;

/**
 * Automated response actions results, displayed in the document details expandable flyout left section under the Insights tab, Response tab
 */
const ResponseDetails = () => {
  const {
    searchHit,
    dataAsNestedObject,
    isPreview
  } = (0, _context.useLeftPanelContext)();
  const endpointResponseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const responseActionsView = (0, _response_actions_view.useResponseActionsView)({
    rawEventData: searchHit,
    ecsData: dataAsNestedObject
  });
  const osqueryView = (0, _osquery_tab.useOsqueryTab)({
    rawEventData: searchHit,
    ecsData: dataAsNestedObject
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.RESPONSE_DETAILS_TEST_ID
  }, isPreview ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.response.previewMessage",
    defaultMessage: "Response is not available in alert preview."
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.response.responseTitle",
    defaultMessage: "Responses"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ExtendedFlyoutWrapper, null, endpointResponseActionsEnabled ? responseActionsView === null || responseActionsView === void 0 ? void 0 : responseActionsView.content : osqueryView === null || osqueryView === void 0 ? void 0 : osqueryView.content)));
};
exports.ResponseDetails = ResponseDetails;
ResponseDetails.displayName = 'ResponseDetails';