"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedCases = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cell_tooltip_wrapper = require("../../shared/components/cell_tooltip_wrapper");
var _links = require("../../../../common/components/links");
var _test_ids = require("./test_ids");
var _use_fetch_related_cases = require("../../shared/hooks/use_fetch_related_cases");
var _expandable_panel = require("../../../shared/components/expandable_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON = 'warning';
const columns = [{
  field: 'title',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.nameColumnLabel",
    defaultMessage: "Name"
  }),
  render: (value, caseData) => /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
    tooltip: caseData.title
  }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: caseData.id,
    title: caseData.title
  }, caseData.title))
}, {
  field: 'status',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.statusColumnLabel",
    defaultMessage: "Status"
  }),
  truncateText: true,
  width: '25%'
}];
/**
 *
 */
const RelatedCases = ({
  eventId
}) => {
  const {
    loading,
    error,
    data,
    dataCount
  } = (0, _use_fetch_related_cases.useFetchRelatedCases)({
    eventId
  });
  if (error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.left.insights.correlations.relatedCasesTitle",
        defaultMessage: "{count} related {count, plural, one {case} other {cases}}",
        values: {
          count: dataCount
        }
      }),
      iconType: ICON
    },
    content: {
      error
    },
    expand: {
      expandable: true,
      expandedOnFirstRender: true
    },
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_CASES_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: loading,
    items: data,
    columns: columns,
    pagination: true,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.relatedCasesNoDataDescription",
      defaultMessage: "No related cases."
    }),
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_CASES_SECTION_TABLE_TEST_ID
  }));
};
exports.RelatedCases = RelatedCases;
RelatedCases.displayName = 'RelatedCases';