"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsDetails = exports.CORRELATIONS_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _related_alerts_by_session = require("./related_alerts_by_session");
var _related_alerts_by_same_source_event = require("./related_alerts_by_same_source_event");
var _related_cases = require("./related_cases");
var _use_show_related_cases = require("../../shared/hooks/use_show_related_cases");
var _use_show_related_alerts_by_ancestry = require("../../shared/hooks/use_show_related_alerts_by_ancestry");
var _use_show_suppressed_alerts = require("../../shared/hooks/use_show_suppressed_alerts");
var _context = require("../context");
var _use_show_related_alerts_by_same_source_event = require("../../shared/hooks/use_show_related_alerts_by_same_source_event");
var _use_show_related_alerts_by_session = require("../../shared/hooks/use_show_related_alerts_by_session");
var _related_alerts_by_ancestry = require("./related_alerts_by_ancestry");
var _suppressed_alerts = require("./suppressed_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CORRELATIONS_TAB_ID = 'correlations-details';

/**
 * Correlations displayed in the document details expandable flyout left section under the Insights tab
 */
exports.CORRELATIONS_TAB_ID = CORRELATIONS_TAB_ID;
const CorrelationsDetails = () => {
  const {
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    eventId,
    getFieldsData,
    scopeId,
    isPreview
  } = (0, _context.useLeftPanelContext)();
  const {
    show: showAlertsByAncestry,
    indices,
    documentId
  } = (0, _use_show_related_alerts_by_ancestry.useShowRelatedAlertsByAncestry)({
    getFieldsData,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    eventId,
    isPreview
  });
  const {
    show: showSameSourceAlerts,
    originalEventId
  } = (0, _use_show_related_alerts_by_same_source_event.useShowRelatedAlertsBySameSourceEvent)({
    getFieldsData
  });
  const {
    show: showAlertsBySession,
    entityId
  } = (0, _use_show_related_alerts_by_session.useShowRelatedAlertsBySession)({
    getFieldsData
  });
  const showCases = (0, _use_show_related_cases.useShowRelatedCases)();
  const {
    show: showSuppressedAlerts,
    alertSuppressionCount
  } = (0, _use_show_suppressed_alerts.useShowSuppressedAlerts)({
    getFieldsData
  });
  const canShowAtLeastOneInsight = showAlertsByAncestry || showSameSourceAlerts || showAlertsBySession || showCases || showSuppressedAlerts;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_TEST_ID,
    color: "transparent"
  }, canShowAtLeastOneInsight ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "column"
  }, showSuppressedAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_suppressed_alerts.SuppressedAlerts, {
    alertSuppressionCount: alertSuppressionCount,
    dataAsNestedObject: dataAsNestedObject
  })), showCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_cases.RelatedCases, {
    eventId: eventId
  })), showSameSourceAlerts && originalEventId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_alerts_by_same_source_event.RelatedAlertsBySameSourceEvent, {
    originalEventId: originalEventId,
    scopeId: scopeId,
    eventId: eventId
  })), showAlertsBySession && entityId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_alerts_by_session.RelatedAlertsBySession, {
    entityId: entityId,
    scopeId: scopeId,
    eventId: eventId
  })), showAlertsByAncestry && documentId && indices && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_alerts_by_ancestry.RelatedAlertsByAncestry, {
    indices: indices,
    scopeId: scopeId,
    documentId: documentId
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.noDataDescription",
    defaultMessage: "No correlations data available."
  }));
};
exports.CorrelationsDetails = CorrelationsDetails;
CorrelationsDetails.displayName = 'CorrelationsDetails';