"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _right = require("../right");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _host_isolation = require("../../../common/components/endpoint/host_isolation");
var _use_host_isolation_tools = require("../../../timelines/components/side_panel/event_details/use_host_isolation_tools");
var _context = require("./context");
var _host_isolation2 = require("../../../detections/components/host_isolation");
var _flyout_body = require("../../shared/components/flyout_body");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details expandable flyout section content for the isolate host component, displaying the form or the success banner
 */
const PanelContent = () => {
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    dataFormattedForFieldBrowser,
    eventId,
    scopeId,
    indexName,
    isolateAction
  } = (0, _context.useIsolateHostPanelContext)();
  const {
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess
  } = (0, _use_host_isolation_tools.useHostIsolationTools)();
  const {
    alertId,
    hostName
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const showAlertDetails = (0, _react.useCallback)(() => openRightPanel({
    id: _right.DocumentDetailsRightPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    }
  }), [eventId, indexName, scopeId, openRightPanel]);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, isIsolateActionSuccessBannerVisible && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
    hostName: hostName,
    alertId: alertId,
    isolateAction: isolateAction
  }), /*#__PURE__*/_react.default.createElement(_host_isolation2.HostIsolationPanel, {
    details: dataFormattedForFieldBrowser,
    cancelCallback: showAlertDetails,
    successCallback: handleIsolationActionSuccess,
    isolateAction: isolateAction
  }));
};
exports.PanelContent = PanelContent;