"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.histogramConfigs = exports.DnsQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _network_dns_table = require("../../components/network_dns_table");
var _network_dns = require("../../containers/network_dns");
var _manage_query = require("../../../../common/components/page/manage_query");
var i18n = _interopRequireWildcard(require("./translations"));
var _matrix_histogram = require("../../../../common/components/matrix_histogram");
var _security_solution = require("../../../../../common/search_strategy/security_solution");
var _store = require("../../store");
var _use_selector = require("../../../../common/hooks/use_selector");
var _dns_top_domains = require("../../../../common/components/visualization_actions/lens_attributes/network/dns_top_domains");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _dnsStackByOptions$fi;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const HISTOGRAM_ID = 'networkDnsHistogramQuery';
const NetworkDnsTableManage = (0, _manage_query.manageQuery)(_network_dns_table.NetworkDnsTable);
const dnsStackByOptions = [{
  text: 'dns.question.registered_domain',
  value: 'dns.question.registered_domain'
}];
const DEFAULT_STACK_BY = 'dns.question.registered_domain';
const histogramConfigs = {
  defaultStackByOption: (_dnsStackByOptions$fi = dnsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _dnsStackByOptions$fi !== void 0 ? _dnsStackByOptions$fi : dnsStackByOptions[0],
  errorMessage: i18n.ERROR_FETCHING_DNS_DATA,
  histogramType: _security_solution.MatrixHistogramType.dns,
  stackByOptions: dnsStackByOptions,
  subtitle: undefined,
  getLensAttributes: _dns_top_domains.getDnsTopDomainsLensAttributes
};
exports.histogramConfigs = histogramConfigs;
const DnsQueryTabBodyComponent = ({
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  skip,
  startDate,
  setQuery,
  type
}) => {
  const getNetworkDnsSelector = _store.networkSelectors.dnsSelector();
  const isPtrIncluded = (0, _use_selector.useShallowEqualSelector)(state => getNetworkDnsSelector(state).isPtrIncluded);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: HISTOGRAM_ID
        });
      }
    };
  }, [deleteQuery]);
  const queryId = `${_network_dns.ID}-${type}`;
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    totalCount,
    networkDns,
    pageInfo,
    loadPage,
    id,
    inspect,
    isInspected,
    refetch
  }] = (0, _network_dns.useNetworkDns)({
    endDate,
    filterQuery,
    id: queryId,
    indexNames,
    skip: querySkip,
    startDate
  });
  const getTitle = (0, _react.useCallback)(option => i18n.DOMAINS_COUNT_BY(option.text), []);
  const dnsHistogramConfigs = (0, _react.useMemo)(() => ({
    ...histogramConfigs,
    title: getTitle
  }), [getTitle]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    id: HISTOGRAM_ID,
    isPtrIncluded: isPtrIncluded,
    endDate: endDate,
    filterQuery: filterQuery,
    indexNames: indexNames,
    setQuery: setQuery,
    showLegend: true,
    startDate: startDate
  }, dnsHistogramConfigs)), /*#__PURE__*/_react.default.createElement(NetworkDnsTableManage, {
    data: networkDns,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: totalCount,
    type: type
  }));
};
DnsQueryTabBodyComponent.displayName = 'DnsQueryTabBodyComponent';
const DnsQueryTabBody = /*#__PURE__*/_react.default.memo(DnsQueryTabBodyComponent);
exports.DnsQueryTabBody = DnsQueryTabBody;