"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.STATUS = exports.ROWS_5 = exports.ROWS_10 = exports.REQUESTS = exports.PATH = exports.METHOD = exports.LAST_SOURCE_IP = exports.LAST_HOST = exports.HTTP_REQUESTS = exports.DOMAIN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HTTP_REQUESTS = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.title', {
  defaultMessage: 'HTTP Requests'
});
exports.HTTP_REQUESTS = HTTP_REQUESTS;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {request} other {requests}}`
});
exports.UNIT = UNIT;
const METHOD = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.methodTitle', {
  defaultMessage: 'Method'
});
exports.METHOD = METHOD;
const DOMAIN = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.domainTitle', {
  defaultMessage: 'Domain'
});
exports.DOMAIN = DOMAIN;
const PATH = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.pathTitle', {
  defaultMessage: 'Path'
});
exports.PATH = PATH;
const STATUS = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.statusTitle', {
  defaultMessage: 'Status'
});
exports.STATUS = STATUS;
const LAST_HOST = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.lastHostTitle', {
  defaultMessage: 'Last host'
});
exports.LAST_HOST = LAST_HOST;
const LAST_SOURCE_IP = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.lastSourceIpTitle', {
  defaultMessage: 'Last source Ip'
});
exports.LAST_SOURCE_IP = LAST_SOURCE_IP;
const REQUESTS = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.column.requestsTitle', {
  defaultMessage: 'Requests'
});
exports.REQUESTS = REQUESTS;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.networkHttpTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;