"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderedFieldValue = exports.PointToolTipContentComponent = exports.PointToolTipContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _map_config = require("../map_config");
var _empty_value = require("../../../../../common/components/empty_value");
var _page = require("../../../../../common/components/page");
var _links = require("../../../../../common/components/links");
var _field_renderers = require("../../../../../timelines/components/field_renderers/field_renderers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PointToolTipContentComponent = ({
  contextId,
  featureProps
}) => {
  const featureDescriptionListItems = (0, _react.useMemo)(() => featureProps.map(featureProp => {
    var _featureProp$getRawVa;
    const key = featureProp.getPropertyKey();
    const value = (_featureProp$getRawVa = featureProp.getRawValue()) !== null && _featureProp$getRawVa !== void 0 ? _featureProp$getRawVa : [];
    return {
      title: _map_config.sourceDestinationFieldMappings[key],
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value != null ? /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
        rowItems: Array.isArray(value) ? value : [value],
        attrName: key,
        idPrefix: `map-point-tooltip-${contextId}-${key}-${value}`,
        render: item => getRenderedFieldValue(key, item)
      }) : (0, _empty_value.getEmptyTagValue)())
    };
  }), [contextId, featureProps]);
  return /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: featureDescriptionListItems
  });
};
exports.PointToolTipContentComponent = PointToolTipContentComponent;
PointToolTipContentComponent.displayName = 'PointToolTipContentComponent';
const PointToolTipContent = /*#__PURE__*/_react.default.memo(PointToolTipContentComponent);
exports.PointToolTipContent = PointToolTipContent;
PointToolTipContent.displayName = 'PointToolTipContent';
const getRenderedFieldValue = (field, value) => {
  if (value === '') {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  } else if (['host.name'].includes(field)) {
    return /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: value
    });
  } else if (['source.ip', 'destination.ip'].includes(field)) {
    const flowTarget = field.split('.')[0];
    return /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      ip: value,
      flowTarget: flowTarget
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
};
exports.getRenderedFieldValue = getRenderedFieldValue;