"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationsQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _matrix_histogram = require("../../../../common/components/matrix_histogram");
var _authentications_host_table = require("../../../components/authentication/authentications_host_table");
var _helpers = require("../../../components/authentication/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HISTOGRAM_QUERY_ID = 'authenticationsHistogramQuery';
const AuthenticationsQueryTabBodyComponent = ({
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: endDate,
    filterQuery: filterQuery,
    id: HISTOGRAM_QUERY_ID,
    indexNames: indexNames,
    setQuery: setQuery,
    startDate: startDate
  }, _helpers.histogramConfigs)), /*#__PURE__*/_react.default.createElement(_authentications_host_table.AuthenticationsHostTable, {
    endDate: endDate,
    filterQuery: filterQuery,
    indexNames: indexNames,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    startDate: startDate,
    type: type,
    skip: skip
  }));
};
AuthenticationsQueryTabBodyComponent.displayName = 'AuthenticationsQueryTabBodyComponent';
const AuthenticationsQueryTabBody = /*#__PURE__*/_react.default.memo(AuthenticationsQueryTabBodyComponent);
exports.AuthenticationsQueryTabBody = AuthenticationsQueryTabBody;
AuthenticationsQueryTabBody.displayName = 'AuthenticationsQueryTabBody';