"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Hosts = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/timelines-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../common/store/inputs/constants");
var _types = require("../../../app/types");
var _filters_global = require("../../../common/components/filters_global");
var _header_page = require("../../../common/components/header_page");
var _last_event_time = require("../../../common/components/last_event_time");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _tab_navigation = require("../../../common/components/navigation/tab_navigation");
var _kpi_hosts = require("../components/kpi_hosts");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _use_global_time = require("../../../common/containers/use_global_time");
var _search_strategy = require("../../../../common/search_strategy");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _store = require("../../../common/store");
var _actions = require("../../../common/store/inputs/actions");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _display = require("./display");
var _hosts_tabs = require("./hosts_tabs");
var _nav_tabs = require("./nav_tabs");
var i18n = _interopRequireWildcard(require("./translations"));
var _store2 = require("../store");
var _helpers = require("../store/helpers");
var _model = require("../store/model");
var _helpers2 = require("../../../timelines/components/timeline/helpers");
var _sourcerer = require("../../../common/containers/sourcerer");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _hosts = require("../containers/hosts");
var _landing_page = require("../../../common/components/landing_page");
var _utils = require("../../../common/components/visualization_actions/utils");
var _use_license = require("../../../common/hooks/use_license");
var _helper_hooks = require("../../../helper_hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const HostsComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerElement = (0, _react.useRef)(null);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.hostsPageEvents)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).graphEventId;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const getHostRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store2.hostsSelectors.hostRiskScoreSeverityFilterSelector(), []);
  const severitySelection = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreFilterQuerySelector(state, _store2.hostsModel.HostsType.page));
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const tabsFilters = _react.default.useMemo(() => {
    const hostNameExistsFilter = (0, _utils.fieldNameExistsFilter)(_types.SecurityPageName.hosts);
    if (tabName === _model.HostsTableType.events) {
      return [...globalFilters, ...hostNameExistsFilter];
    }
    if (tabName === _model.HostsTableType.risk) {
      const severityFilter = (0, _helpers.generateSeverityFilter)(severitySelection, _search_strategy.RiskScoreEntity.host);
      return [...globalFilters, ...hostNameExistsFilter, ...severityFilter];
    }
    return globalFilters;
  }, [globalFilters, severitySelection, tabName]);
  const updateDateRange = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch]);
  const {
    indicesExist,
    indexPattern,
    selectedPatterns,
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)();
  const [globalFilterQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [query],
    filters: globalFilters
  }), [globalFilters, indexPattern, uiSettings, query]);
  const [tabsFilterQuery] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [query],
    filters: tabsFilters
  }), [indexPattern, query, tabsFilters, uiSettings]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _hosts.ID,
    filterQuery: globalFilterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('.inspectButtonComponent:last-of-type')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers2.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers2.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    show: (0, _helpers2.showGlobalFilters)({
      globalFullScreen,
      graphEventId
    })
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    sourcererDataView: sourcererDataView
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.hosts,
      indexNames: selectedPatterns
    }),
    title: i18n.PAGE_TITLE,
    border: true
  }), /*#__PURE__*/_react.default.createElement(_kpi_hosts.HostsKpiComponent, {
    filterQuery: globalFilterQuery,
    indexNames: selectedPatterns,
    from: from,
    setQuery: setQuery,
    to: to,
    skip: isInitializing || !!kqlError,
    updateDateRange: updateDateRange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _nav_tabs.navTabsHosts)({
      hasMlUserPermissions: (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities),
      isRiskyHostsEnabled: hasEntityAnalyticsCapability,
      isEnterprise: isEnterprisePlus
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_hosts_tabs.HostsTabs, {
    deleteQuery: deleteQuery,
    to: to,
    filterQuery: tabsFilterQuery,
    isInitializing: isInitializing,
    indexNames: selectedPatterns,
    setQuery: setQuery,
    from: from,
    type: _store2.hostsModel.HostsType.page
  }))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.hosts
  }));
};
HostsComponent.displayName = 'HostsComponent';
const Hosts = /*#__PURE__*/_react.default.memo(HostsComponent);
exports.Hosts = Hosts;