"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetailsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _search_strategy = require("../../../../../common/search_strategy");
var _risk_details_tab_body = require("../../../components/risk_score/risk_details_tab_body");
var _model = require("../../store/model");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _anomalies_host_table = require("../../../../common/components/ml/tables/anomalies_host_table");
var _events_tab = require("../../../../common/components/events_tab");
var _navigation = require("../navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostDetailsTabs = /*#__PURE__*/_react.default.memo(({
  detailName,
  filterQuery,
  indexNames,
  indexPattern,
  hostDetailsPagePath,
  hostDetailsFilter
}) => {
  const {
    from,
    to,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const tabProps = {
    deleteQuery,
    endDate: to,
    filterQuery,
    skip: isInitializing || filterQuery === undefined,
    setQuery,
    startDate: from,
    type: _model.HostsType.details,
    indexPattern,
    indexNames,
    hostName: detailName
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.authentications})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.AuthenticationsQueryTabBody, tabProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.uncommonProcesses})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.UncommonProcessQueryTabBody, tabProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.anomalies})`
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    AnomaliesTableComponent: _anomalies_host_table.AnomaliesHostTable
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.events})`
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: hostDetailsFilter,
    tableId: _securitysolutionDataTable.TableId.hostsPageEvents
  }, tabProps))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.risk})`
  }, /*#__PURE__*/_react.default.createElement(_risk_details_tab_body.RiskDetailsTabBody, (0, _extends2.default)({}, tabProps, {
    riskEntity: _search_strategy.RiskScoreEntity.host,
    entityName: tabProps.hostName
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.sessions})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.SessionsTabBody, tabProps)));
});
exports.HostDetailsTabs = HostDetailsTabs;
HostDetailsTabs.displayName = 'HostDetailsTabs';