"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostRiskScoreColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cell_actions = require("../../../../common/components/cell_actions");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../store/model");
var _search_strategy = require("../../../../../common/search_strategy");
var _common = require("../../../components/risk_score/severity/common");
var _translations2 = require("../../../components/risk_score/translations");
var _constants = require("../../../components/risk_score/constants");
var _formatted_date = require("../../../../common/components/formatted_date");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostRiskScoreColumns = ({
  dispatchSeverityUpdate
}) => [{
  field: 'host.name',
  name: i18n.HOST_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  width: '35%',
  render: hostName => {
    if (hostName != null && hostName.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value: hostName,
          field: 'host.name'
        },
        metadata: {
          telemetry: _constants.CELL_ACTIONS_TELEMETRY
        }
      }, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: hostName,
        hostTab: _model.HostsTableType.risk
      }));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.timestamp,
  name: i18n.LAST_UPDATED,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: lastSeen => {
    if (lastSeen != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastSeen
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.hostRiskScore,
  name: i18n.HOST_RISK_SCORE,
  truncateText: true,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "risk-score-truncate",
        title: `${riskScore}`
      }, Math.round(riskScore));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.hostRisk,
  name: (0, _translations2.ENTITY_RISK_LEVEL)(_search_strategy.RiskScoreEntity.host),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: risk => {
    if (risk != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => dispatchSeverityUpdate(risk)
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, i18n.VIEW_HOSTS_BY_SEVERITY(risk.toLowerCase()))),
        severity: risk
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}];
exports.getHostRiskScoreColumns = getHostRiskScoreColumns;