"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScoreKpi = void 0;
var _react = require("react");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _exceptions = require("../../../../common/utils/exceptions");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_risk_engine_status = require("../../../../entity_analytics/api/hooks/use_risk_engine_status");
var _feature_status = require("../feature_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskScoreKpi = ({
  filterQuery,
  skip,
  riskEntity,
  timerange
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const isNewRiskScoreModuleInstalled = (0, _use_risk_engine_status.useIsNewRiskScoreModuleInstalled)();
  const defaultIndex = spaceId ? riskEntity === _search_strategy.RiskScoreEntity.host ? (0, _search_strategy.getHostRiskIndex)(spaceId, true, isNewRiskScoreModuleInstalled) : (0, _search_strategy.getUserRiskIndex)(spaceId, true, isNewRiskScoreModuleInstalled) : undefined;
  const {
    isDeprecated,
    isEnabled,
    isAuthorized,
    isLoading: isDeprecatedLoading,
    refetch: refetchFeatureStatus
  } = (0, _feature_status.useRiskScoreFeatureStatus)(riskEntity, defaultIndex);
  const {
    loading,
    result,
    search,
    refetch,
    inspect,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.RiskQueries.kpiRiskScore,
    initialResult: {
      kpiRiskScore: _search_strategy.EMPTY_SEVERITY_COUNT
    },
    abort: skip,
    showErrorToast: false
  });
  const isModuleDisabled = !!error && (0, _exceptions.isIndexNotFoundError)(error);
  const requestTimerange = (0, _react.useMemo)(() => timerange ? {
    to: timerange.to,
    from: timerange.from,
    interval: ''
  } : undefined, [timerange]);
  (0, _react.useEffect)(() => {
    if (!skip && defaultIndex && !isDeprecatedLoading && isAuthorized && isEnabled && !isDeprecated) {
      search({
        filterQuery,
        defaultIndex: [defaultIndex],
        entity: riskEntity,
        timerange: requestTimerange
      });
    }
  }, [defaultIndex, search, filterQuery, skip, riskEntity, requestTimerange, isEnabled, isDeprecated, isAuthorized, isDeprecatedLoading]);
  const refetchAll = (0, _react.useCallback)(() => {
    if (defaultIndex) {
      refetchFeatureStatus(defaultIndex);
      refetch();
    }
  }, [defaultIndex, refetch, refetchFeatureStatus]);
  (0, _react.useEffect)(() => {
    if (error) {
      if (!(0, _exceptions.isIndexNotFoundError)(error)) {
        addError(error, {
          title: i18n.FAIL_RISK_SCORE
        });
      }
    }
  }, [addError, error]);
  const severityCount = (0, _react.useMemo)(() => {
    var _result$kpiRiskScore$, _result$kpiRiskScore$2, _result$kpiRiskScore$3, _result$kpiRiskScore$4, _result$kpiRiskScore$5;
    if (loading || error) {
      return undefined;
    }
    return {
      [_search_strategy.RiskSeverity.unknown]: (_result$kpiRiskScore$ = result.kpiRiskScore[_search_strategy.RiskSeverity.unknown]) !== null && _result$kpiRiskScore$ !== void 0 ? _result$kpiRiskScore$ : 0,
      [_search_strategy.RiskSeverity.low]: (_result$kpiRiskScore$2 = result.kpiRiskScore[_search_strategy.RiskSeverity.low]) !== null && _result$kpiRiskScore$2 !== void 0 ? _result$kpiRiskScore$2 : 0,
      [_search_strategy.RiskSeverity.moderate]: (_result$kpiRiskScore$3 = result.kpiRiskScore[_search_strategy.RiskSeverity.moderate]) !== null && _result$kpiRiskScore$3 !== void 0 ? _result$kpiRiskScore$3 : 0,
      [_search_strategy.RiskSeverity.high]: (_result$kpiRiskScore$4 = result.kpiRiskScore[_search_strategy.RiskSeverity.high]) !== null && _result$kpiRiskScore$4 !== void 0 ? _result$kpiRiskScore$4 : 0,
      [_search_strategy.RiskSeverity.critical]: (_result$kpiRiskScore$5 = result.kpiRiskScore[_search_strategy.RiskSeverity.critical]) !== null && _result$kpiRiskScore$5 !== void 0 ? _result$kpiRiskScore$5 : 0
    };
  }, [result, loading, error]);
  return {
    error,
    severityCount,
    loading,
    isModuleDisabled,
    refetch: refetchAll,
    inspect
  };
};
exports.useRiskScoreKpi = useRiskScoreKpi;