"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_RISK_DESCRIPTION = exports.TITLE = exports.INFO_BUTTON_TEXT = exports.INFORMATION_RISK_HEADER = exports.INFORMATION_LEVEL_HEADER = exports.INFORMATION_ARIA_LABEL = exports.CRITICAL_RISK_DESCRIPTION = exports.CLOSE_BUTTON_TEXT = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFORMATION_LEVEL_HEADER = _i18n.i18n.translate('xpack.securitySolution.riskInformation.levelHeader', {
  defaultMessage: 'Level'
});
exports.INFORMATION_LEVEL_HEADER = INFORMATION_LEVEL_HEADER;
const INFORMATION_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.riskInformation.informationAriaLabel', {
  defaultMessage: 'Information'
});
exports.INFORMATION_ARIA_LABEL = INFORMATION_ARIA_LABEL;
const INFORMATION_RISK_HEADER = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskInformation.riskHeader', {
  defaultMessage: '{riskEntity} risk score range',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.INFORMATION_RISK_HEADER = INFORMATION_RISK_HEADER;
const UNKNOWN_RISK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskInformation.unknownRiskDescription', {
  defaultMessage: 'Less than 20'
});
exports.UNKNOWN_RISK_DESCRIPTION = UNKNOWN_RISK_DESCRIPTION;
const CRITICAL_RISK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskInformation.criticalRiskDescription', {
  defaultMessage: '90 and above'
});
exports.CRITICAL_RISK_DESCRIPTION = CRITICAL_RISK_DESCRIPTION;
const TITLE = _i18n.i18n.translate('xpack.securitySolution.riskInformation.title', {
  defaultMessage: 'Entity Risk Analytics'
});
exports.TITLE = TITLE;
const CLOSE_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.riskInformation.closeBtn', {
  defaultMessage: 'Close'
});
exports.CLOSE_BUTTON_TEXT = CLOSE_BUTTON_TEXT;
const INFO_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.riskInformation.buttonLabel', {
  defaultMessage: 'How is risk score calculated?'
});
exports.INFO_BUTTON_TEXT = INFO_BUTTON_TEXT;