"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationEuiFlexItem = exports.PaginatedTable = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../common/constants");
var _header_section = require("../../../common/components/header_section");
var _loader = require("../../../common/components/loader");
var _toasters = require("../../../common/components/toasters");
var i18n = _interopRequireWildcard(require("./translations"));
var _panel = require("../../../common/components/panel");
var _inspect = require("../../../common/components/inspect");
var _query_toggle = require("../../../common/containers/query_toggle");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATA_TEST_SUBJ = 'paginated-table';

// Using telescoping templates to remove 'any' that was polluting downstream column type checks

const PaginatedTableComponent = ({
  activePage,
  columns,
  dataTestSubj = DEFAULT_DATA_TEST_SUBJ,
  headerCount,
  headerFilters,
  headerSupplement,
  headerTitle,
  headerTooltip,
  headerUnit,
  headerSubtitle,
  id,
  isInspect,
  itemsPerRow,
  limit,
  loading,
  loadPage,
  onChange = _fp.noop,
  pageOfItems,
  setQuerySkip,
  showMorePagesIndicator,
  sorting = null,
  split,
  stackHeader,
  totalCount,
  updateActivePage,
  updateLimitPagination
}) => {
  const [myLoading, setMyLoading] = (0, _react.useState)(loading);
  const [myActivePage, setActivePage] = (0, _react.useState)(activePage);
  const [loadingInitial, setLoadingInitial] = (0, _react.useState)(headerCount === -1);
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const pageCount = Math.ceil(totalCount / limit);
  const dispatchToaster = (0, _toasters.useStateToaster)()[1];
  (0, _react.useEffect)(() => {
    setActivePage(activePage);
  }, [activePage]);
  (0, _react.useEffect)(() => {
    if (headerCount >= 0 && loadingInitial) {
      setLoadingInitial(false);
    }
  }, [loadingInitial, headerCount]);
  (0, _react.useEffect)(() => {
    setMyLoading(loading);
  }, [loading]);
  const onButtonClick = () => {
    setPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopoverOpen(false);
  };
  const goToPage = newActivePage => {
    if ((newActivePage + 1) * limit >= _constants.DEFAULT_MAX_TABLE_QUERY_SIZE) {
      const toast = {
        id: 'PaginationWarningMsg',
        title: headerTitle + i18n.TOAST_TITLE,
        color: 'warning',
        iconType: 'warning',
        toastLifeTimeMs: 10000,
        text: i18n.TOAST_TEXT
      };
      return dispatchToaster({
        type: 'addToaster',
        toast
      });
    }
    setActivePage(newActivePage);
    loadPage(newActivePage);
    updateActivePage(newActivePage);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick
  }, `${i18n.ROWS}: ${limit}`);
  const rowItems = itemsPerRow && itemsPerRow.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: item.text,
    icon: limit === item.numberOfRow ? 'check' : 'empty',
    onClick: () => {
      closePopover();
      updateLimitPagination(item.numberOfRow);
      updateActivePage(0); // reset results to first page
    }
  }, item.text));
  const PaginationWrapper = showMorePagesIndicator ? PaginationEuiFlexItem : _eui.EuiFlexItem;
  const tableSorting = (0, _react.useMemo)(() => sorting ? {
    sort: {
      field: sorting.field,
      direction: sorting.direction
    }
  } : undefined, [sorting]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(id);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggle on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: !loadingInitial
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    "data-test-subj": `${dataTestSubj}-loading-${loading}`,
    loading: loading
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    toggleStatus: toggleStatus,
    toggleQuery: toggleQuery,
    headerFilters: headerFilters,
    id: id,
    split: split,
    stackHeader: stackHeader,
    subtitle: !loadingInitial && headerSubtitle ? `${i18n.SHOWING}: ${headerSubtitle}` : headerUnit && `${i18n.SHOWING}: ${headerCount >= 0 ? headerCount.toLocaleString() : 0} ${headerUnit}`,
    title: headerTitle,
    tooltip: headerTooltip
  }, !loadingInitial && headerSupplement), toggleStatus && (loadingInitial ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "initialLoadingPanelPaginatedTable",
    lines: 10
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(BasicTable, {
    "data-test-subj": "paginated-basic-table",
    columns: columns,
    items: pageOfItems,
    onChange: onChange,
    sorting: tableSorting
  }), /*#__PURE__*/_react.default.createElement(FooterAction, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, itemsPerRow && itemsPerRow.length > 0 && totalCount >= itemsPerRow[0].numberOfRow && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "customizablePagination",
    "data-test-subj": "loadingMoreSizeRowPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: rowItems,
    "data-test-subj": "loadingMorePickSizeRow"
  }))), /*#__PURE__*/_react.default.createElement(PaginationWrapper, {
    grow: false
  }, totalCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "data-test-subj": "numberedPagination",
    pageCount: pageCount,
    activePage: myActivePage,
    onPageClick: goToPage
  }))), (isInspect || myLoading) && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    "data-test-subj": "loadingPanelPaginatedTable",
    overlay: true,
    size: "xl"
  })))));
};
const PaginatedTable = /*#__PURE__*/(0, _react.memo)(PaginatedTableComponent);
exports.PaginatedTable = PaginatedTable;
// eslint-disable-line @typescript-eslint/no-explicit-any
const BasicTable = (0, _styledComponents.default)(_eui.EuiBasicTable)`
  tbody {
    th,
    td {
      vertical-align: top;
    }

    .euiTableCellContent {
      display: block;
    }
  }
`; // eslint-disable-line @typescript-eslint/no-explicit-any

BasicTable.displayName = 'BasicTable';
const FooterAction = (0, _styledComponents.default)(_eui.EuiFlexGroup).attrs(() => ({
  alignItems: 'center',
  responsive: false
}))`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
FooterAction.displayName = 'FooterAction';
const PaginationEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    .euiButtonIcon:last-child {
      margin-left: 28px;
    }

    .euiPagination {
      position: relative;
    }

    .euiPagination::before {
      bottom: 0;
      color: ${({
  theme
}) => theme.eui.euiButtonColorDisabled};
      content: '\\2026';
      font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
      padding: 5px ${({
  theme
}) => theme.eui.euiSizeS};
      position: absolute;
      right: ${({
  theme
}) => theme.eui.euiSizeL};
    }
  }
`;
exports.PaginationEuiFlexItem = PaginationEuiFlexItem;
PaginationEuiFlexItem.displayName = 'PaginationEuiFlexItem';