"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var _spy_routes = require("../common/utils/route/spy_routes");
var _ = require("../app/404");
var _constants = require("../../common/constants");
var _entity_analytics_management_page = require("./pages/entity_analytics_management_page");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsTelemetry = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.entityAnalyticsManagement
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_management_page.EntityAnalyticsManagementPage, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants.SecurityPageName.entityAnalyticsManagement
})));
const EntityAnalyticsContainer = () => {
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsTelemetry
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
};
const EntityAnalytics = /*#__PURE__*/_react.default.memo(EntityAnalyticsContainer);
const renderEntityAnalyticsRoutes = () => /*#__PURE__*/_react.default.createElement(EntityAnalytics, null);
const routes = [{
  path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
  render: renderEntityAnalyticsRoutes
}];
exports.routes = routes;