"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMissingPrivileges = void 0;
var _react = require("react");
var _use_risk_engine_privileges = require("../../api/hooks/use_risk_engine_privileges");
var _risk_engine = require("../../../../common/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMissingIndexPrivileges = privileges => {
  const missingIndexPrivileges = [];
  if (!privileges) {
    return missingIndexPrivileges;
  }
  for (const [indexName, requiredPrivileges] of Object.entries(_risk_engine.RISK_ENGINE_REQUIRED_ES_INDEX_PRIVILEGES)) {
    const missingPrivileges = requiredPrivileges.filter(privilege => !privileges[indexName][privilege]);
    if (missingPrivileges.length) {
      missingIndexPrivileges.push([indexName, missingPrivileges]);
    }
  }
  return missingIndexPrivileges;
};
const useMissingPrivileges = () => {
  const {
    data: privilegesResponse,
    isLoading
  } = (0, _use_risk_engine_privileges.useRiskEnginePrivileges)();
  return (0, _react.useMemo)(() => {
    if (isLoading || !privilegesResponse) {
      return {
        isLoading: true
      };
    }
    if (privilegesResponse.has_all_required) {
      return {
        isLoading: false,
        hasAllRequiredPrivileges: true
      };
    }
    const {
      privileges
    } = privilegesResponse;
    const missinIndexPrivileges = getMissingIndexPrivileges(privileges.elasticsearch.index);
    const missingClusterPrivileges = _risk_engine.RISK_ENGINE_REQUIRED_ES_CLUSTER_PRIVILEGES.filter(privilege => {
      var _privileges$elasticse;
      return !((_privileges$elasticse = privileges.elasticsearch.cluster) !== null && _privileges$elasticse !== void 0 && _privileges$elasticse[privilege]);
    });
    return {
      isLoading: false,
      hasAllRequiredPrivileges: false,
      missingPrivileges: {
        indexPrivileges: missinIndexPrivileges,
        clusterPrivileges: missingClusterPrivileges
      }
    };
  }, [isLoading, privilegesResponse]);
};
exports.useMissingPrivileges = useMissingPrivileges;