"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEVERITY_UI_SORT_ORDER = exports.RISK_SEVERITY_COLOUR = exports.RISK_SCORE_RANGES = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _search_strategy = require("../../../common/search_strategy");
var _utils = require("../../overview/components/detection_response/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEVERITY_UI_SORT_ORDER = [_search_strategy.RiskSeverity.unknown, _search_strategy.RiskSeverity.low, _search_strategy.RiskSeverity.moderate, _search_strategy.RiskSeverity.high, _search_strategy.RiskSeverity.critical];
exports.SEVERITY_UI_SORT_ORDER = SEVERITY_UI_SORT_ORDER;
const RISK_SEVERITY_COLOUR = {
  [_search_strategy.RiskSeverity.unknown]: _uiTheme.euiLightVars.euiColorMediumShade,
  [_search_strategy.RiskSeverity.low]: _utils.SEVERITY_COLOR.low,
  [_search_strategy.RiskSeverity.moderate]: _utils.SEVERITY_COLOR.medium,
  [_search_strategy.RiskSeverity.high]: _utils.SEVERITY_COLOR.high,
  [_search_strategy.RiskSeverity.critical]: _utils.SEVERITY_COLOR.critical
};
exports.RISK_SEVERITY_COLOUR = RISK_SEVERITY_COLOUR;
const RISK_SCORE_RANGES = {
  [_search_strategy.RiskSeverity.unknown]: {
    start: 0,
    stop: 20
  },
  [_search_strategy.RiskSeverity.low]: {
    start: 20,
    stop: 40
  },
  [_search_strategy.RiskSeverity.moderate]: {
    start: 40,
    stop: 70
  },
  [_search_strategy.RiskSeverity.high]: {
    start: 70,
    stop: 90
  },
  [_search_strategy.RiskSeverity.critical]: {
    start: 90,
    stop: 100
  }
};
exports.RISK_SCORE_RANGES = RISK_SCORE_RANGES;