"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionEngineNoIndex = void 0;
var _react = _interopRequireWildcard(require("react"));
var _empty_page = require("../../../common/components/empty_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildMessage = (needsListsIndex, needsSignalsIndex) => {
  if (needsSignalsIndex && needsListsIndex) {
    return i18n.NEEDS_INDEX_PERMISSIONS(i18n.NEEDS_SIGNALS_AND_LISTS_INDEXES);
  } else if (needsSignalsIndex) {
    return i18n.NEEDS_INDEX_PERMISSIONS(i18n.NEEDS_SIGNALS_INDEX);
  } else if (needsListsIndex) {
    return i18n.NEEDS_INDEX_PERMISSIONS(i18n.NEEDS_LISTS_INDEXES);
  } else {
    return i18n.NEEDS_INDEX_PERMISSIONS('');
  }
};
const DetectionEngineNoIndexComponent = ({
  needsListsIndex,
  needsSignalsIndex
}) => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const actions = (0, _react.useMemo)(() => ({
    detections: {
      icon: 'documents',
      label: i18n.GO_TO_DOCUMENTATION,
      url: `${docLinks.links.siem.detectionsReq}`,
      target: '_blank'
    }
  }), [docLinks]);
  const message = buildMessage(needsListsIndex, needsSignalsIndex);
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: actions,
    "data-test-subj": "no_index",
    message: message,
    title: i18n.NO_INDEX_TITLE
  });
};
const DetectionEngineNoIndex = /*#__PURE__*/_react.default.memo(DetectionEngineNoIndexComponent);
exports.DetectionEngineNoIndex = DetectionEngineNoIndex;