"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartContextMenu = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _chart_settings_popover = require("../../../../../common/components/chart_settings_popover");
var _default = require("../../../../../common/components/chart_settings_popover/configurations/default");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartContextMenuComponent = ({
  defaultStackByField,
  defaultStackByField1,
  onReset = _fp.noop,
  queryId,
  setStackBy,
  setStackByField1
}) => {
  const onResetStackByFields = (0, _react.useCallback)(() => {
    onReset();
    setStackBy(defaultStackByField);
    if (setStackByField1 != null) {
      setStackByField1(defaultStackByField1);
    }
  }, [defaultStackByField, defaultStackByField1, onReset, setStackBy, setStackByField1]);
  const {
    defaultInitialPanelId,
    defaultMenuItems,
    isPopoverOpen,
    setIsPopoverOpen
  } = (0, _default.useChartSettingsPopoverConfiguration)({
    onResetStackByFields,
    queryId
  });
  return /*#__PURE__*/_react.default.createElement(_chart_settings_popover.ChartSettingsPopover, {
    initialPanelId: defaultInitialPanelId,
    isPopoverOpen: isPopoverOpen,
    panels: defaultMenuItems,
    setIsPopoverOpen: setIsPopoverOpen
  });
};
ChartContextMenuComponent.displayName = 'ChartContextMenuComponent';
const ChartContextMenu = /*#__PURE__*/_react.default.memo(ChartContextMenuComponent);
exports.ChartContextMenu = ChartContextMenu;