"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchPageContext = exports.profileUidColumns = void 0;
var _react = require("react");
var _use_bulk_get_user_profiles = require("../../../common/components/user_profiles/use_bulk_get_user_profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Add new columns names to this array to render the user's display name instead of profile_uid
const profileUidColumns = ['kibana.alert.workflow_assignee_ids', 'kibana.alert.workflow_user'];
exports.profileUidColumns = profileUidColumns;
const useFetchPageContext = ({
  alerts,
  columns
}) => {
  const uids = new Set();
  alerts.forEach(alert => {
    profileUidColumns.forEach(columnId => {
      if (columns.find(column => column.id === columnId) != null) {
        const userUids = alert[columnId];
        userUids === null || userUids === void 0 ? void 0 : userUids.forEach(uid => uids.add(uid));
      }
    });
  });
  const result = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids
  });
  const returnVal = (0, _react.useMemo)(() => ({
    profiles: result.data,
    isLoading: result.isLoading
  }), [result.data, result.isLoading]);
  return returnVal;
};
exports.useFetchPageContext = useFetchPageContext;