"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderCellValue = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../common/components/draggables");
var _truncatable_text = require("../../../../common/components/truncatable_text");
var _severity = require("../../../components/severity");
var _data_driven_columns = require("../../../../timelines/components/timeline/body/data_driven_columns");
var _default_cell_renderer = require("../../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reason = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.';

/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */
const RenderCellValue = ({
  columnId,
  data,
  eventId,
  header,
  isDetails,
  isExpandable,
  isExpanded,
  linkValues,
  rowIndex,
  colIndex,
  setCellProps,
  key,
  scopeId
}) => {
  var _useGetMappedNonEcsVa, _useGetMappedNonEcsVa2;
  const value = (_useGetMappedNonEcsVa = (_useGetMappedNonEcsVa2 = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data,
    fieldName: columnId
  })) === null || _useGetMappedNonEcsVa2 === void 0 ? void 0 : _useGetMappedNonEcsVa2.reduce(x => x[0])) !== null && _useGetMappedNonEcsVa !== void 0 ? _useGetMappedNonEcsVa : '';
  const draggableId = `${key}-${eventId}-${columnId}-${value}`;
  switch (columnId) {
    case 'signal.rule.severity':
    case _ruleDataUtils.ALERT_SEVERITY:
      return /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
        "data-test-subj": "custom-severity",
        field: columnId,
        id: draggableId,
        value: value,
        scopeId: scopeId
      }, /*#__PURE__*/_react.default.createElement(_severity.Severity, {
        severity: value
      }));
    case 'signal.reason':
    case _ruleDataUtils.ALERT_REASON:
      return /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
        "data-test-subj": "custom-reason"
      }, reason);
    default:
      return /*#__PURE__*/_react.default.createElement(_default_cell_renderer.DefaultCellRenderer, {
        columnId: columnId,
        data: data,
        eventId: eventId,
        header: header,
        isDetails: isDetails,
        isDraggable: false,
        isExpandable: isExpandable,
        isExpanded: isExpanded,
        linkValues: linkValues,
        rowIndex: rowIndex,
        colIndex: colIndex,
        setCellProps: setCellProps,
        scopeId: scopeId
      });
  }
};
exports.RenderCellValue = RenderCellValue;